/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Element;
import com.tailf.jnc.Prefix;
import java.util.ArrayList;

public class PrefixMap
extends ArrayList<Prefix> {
    private static final long serialVersionUID = 1L;

    public PrefixMap() {
    }

    public PrefixMap(Prefix prefix) {
        this.add(prefix);
    }

    public PrefixMap(Prefix[] prefixArray) {
        for (Prefix prefix : prefixArray) {
            this.add(prefix);
        }
    }

    public void merge(PrefixMap prefixMap) {
        for (Prefix prefix : prefixMap) {
            this.merge(prefix);
        }
    }

    public void merge(Prefix prefix) {
        int n = this.indexOfName(prefix.name);
        if (n == -1) {
            this.add(prefix);
        }
    }

    public void set(PrefixMap prefixMap) {
        this.trace("set: " + prefixMap);
        for (Prefix prefix : prefixMap) {
            this.set(prefix);
        }
    }

    public void set(Prefix prefix) {
        int n = this.indexOfName(prefix.name);
        if (n == -1) {
            if (prefix.name.equals("")) {
                this.add(0, prefix);
            } else {
                this.add(prefix);
            }
        } else {
            this.set(n, prefix);
        }
    }

    public void remove(String string) {
        int n = this.indexOfName(string);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public Prefix getPrefix(int n) {
        return (Prefix)super.get(n);
    }

    public int indexOfName(String string) {
        for (int i = 0; i < this.size(); ++i) {
            if (!string.equals(this.getPrefix((int)i).name)) continue;
            return i;
        }
        return -1;
    }

    public Prefix lookup(String string) {
        for (int i = 0; i < this.size(); ++i) {
            Prefix prefix = this.getPrefix(i);
            if (!string.equals(prefix.name)) continue;
            return prefix;
        }
        return null;
    }

    public String nsToPrefix(String string) {
        for (int i = 0; i < this.size(); ++i) {
            Prefix prefix = this.getPrefix(i);
            if (prefix.ns == null || !string.equals(prefix.value)) continue;
            return prefix.name;
        }
        return null;
    }

    public String prefixToNs(String string) {
        for (int i = 0; i < this.size(); ++i) {
            Prefix prefix = this.getPrefix(i);
            if (!string.equals(prefix.name)) continue;
            return prefix.value;
        }
        return null;
    }

    private void trace(String string) {
        if (Element.debugLevel >= 4) {
            System.err.println("*PrefixMap: " + string);
        }
    }
}

