/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import ch.ethz.ssh2.Session;
import com.tailf.jnc.Element;
import com.tailf.jnc.IOSubscriber;
import com.tailf.jnc.JNCException;
import com.tailf.jnc.SSHConnection;
import com.tailf.jnc.Transport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;

public class SSHSession
implements Transport {
    private SSHConnection connection = null;
    private Session session = null;
    private BufferedReader in = null;
    private PrintWriter out = null;
    private final ArrayList<IOSubscriber> ioSubscribers;
    protected long readTimeout = 0L;
    private static final String endmarker = "]]>]]>";
    private static final int end = "]]>]]>".length() - 1;

    public SSHSession(SSHConnection sSHConnection) throws IOException, JNCException {
        this(sSHConnection, 0L);
    }

    public SSHSession(SSHConnection sSHConnection, long l) throws IOException, JNCException {
        this.readTimeout = l;
        this.connection = sSHConnection;
        this.session = sSHConnection.connection.openSession();
        this.session.startSubSystem("netconf");
        InputStream inputStream = this.session.getStdout();
        OutputStream outputStream = this.session.getStdin();
        this.in = new BufferedReader(new InputStreamReader(inputStream));
        this.out = new PrintWriter(outputStream, false);
        this.ioSubscribers = new ArrayList();
    }

    public SSHConnection getSSHConnection() {
        return this.connection;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    @Override
    public boolean ready() throws IOException {
        if (this.in.ready()) {
            return true;
        }
        int n = this.session.waitForCondition(-1, 1L);
        return (n & 1) != 1;
    }

    public boolean serverSideClosed() throws IOException {
        int n = 0;
        return ((n = this.session.waitForCondition(n, 1L)) & 1) != 1;
    }

    public int readUntilWouldBlock() {
        int n = 0;
        try {
            while (true) {
                if (!this.ready()) {
                    return n;
                }
                this.in.read();
                ++n;
            }
        }
        catch (IOException iOException) {
            return n;
        }
    }

    @Override
    public StringBuffer readOne() throws IOException, JNCException {
        StringWriter stringWriter = new StringWriter();
        block0: while (true) {
            int n;
            if (this.readTimeout > 0L && !this.in.ready() && ((n = this.session.waitForCondition(-1, this.readTimeout)) & 1) == 1) {
                throw new JNCException(-11, this.readTimeout);
            }
            int n2 = this.in.read();
            if (n2 == -1) {
                SSHSession.trace("end of input (-1)");
                throw new IOException("Session closed");
            }
            n = 0;
            while (true) {
                if (n >= endmarker.length()) continue block0;
                if (n2 == endmarker.charAt(n)) {
                    if (n >= end) {
                        for (IOSubscriber iOSubscriber : this.ioSubscribers) {
                            iOSubscriber.inputFlush(endmarker.substring(0, end));
                        }
                        return stringWriter.getBuffer();
                    }
                } else {
                    this.subInputChar(stringWriter, endmarker.substring(0, n));
                    this.subInputChar(stringWriter, n2);
                    continue block0;
                }
                n2 = this.in.read();
                ++n;
            }
            break;
        }
    }

    private void subInputChar(StringWriter stringWriter, int n) {
        stringWriter.write(n);
        for (int i = 0; i < this.ioSubscribers.size(); ++i) {
            IOSubscriber iOSubscriber = this.ioSubscribers.get(i);
            iOSubscriber.inputChar(n);
        }
    }

    private void subInputChar(StringWriter stringWriter, String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.subInputChar(stringWriter, string.charAt(i));
        }
    }

    @Override
    public void print(int n) {
        for (IOSubscriber iOSubscriber : this.ioSubscribers) {
            iOSubscriber.outputPrint(n);
        }
        this.out.print(n);
    }

    @Override
    public void print(String string) {
        for (IOSubscriber iOSubscriber : this.ioSubscribers) {
            iOSubscriber.outputPrint(string);
        }
        this.out.print(string);
    }

    @Override
    public void println(int n) {
        for (IOSubscriber iOSubscriber : this.ioSubscribers) {
            iOSubscriber.outputPrintln(n);
        }
        this.out.println(n);
    }

    @Override
    public void println(String string) {
        for (IOSubscriber iOSubscriber : this.ioSubscribers) {
            iOSubscriber.outputPrintln(string);
        }
        this.out.println(string);
    }

    public void addSubscriber(IOSubscriber iOSubscriber) {
        this.ioSubscribers.add(iOSubscriber);
    }

    public void delSubscriber(IOSubscriber iOSubscriber) {
        for (int i = 0; i < this.ioSubscribers.size(); ++i) {
            IOSubscriber iOSubscriber2 = this.ioSubscribers.get(i);
            if (!iOSubscriber.equals(iOSubscriber2)) continue;
            this.ioSubscribers.remove(i);
            return;
        }
    }

    @Override
    public void flush() {
        this.out.print(endmarker);
        this.out.flush();
        for (IOSubscriber iOSubscriber : this.ioSubscribers) {
            iOSubscriber.outputFlush(endmarker);
        }
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public void close() {
        this.session.close();
    }

    private static void trace(String string) {
        if (Element.debugLevel >= 2) {
            System.err.println("*SSHSession: " + string);
        }
    }
}

