/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.JNCException;
import com.tailf.jnc.RevisionInfo;
import com.tailf.jnc.SchemaNode;
import com.tailf.jnc.Tagpath;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SchemaParser {
    protected XMLReader parser;

    public SchemaParser() throws JNCException {
        try {
            String string = System.getProperty("java.version");
            this.parser = string.startsWith("1.4") ? XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl") : XMLReaderFactory.createXMLReader();
        }
        catch (Exception exception) {
            System.exit(-1);
            throw new JNCException(-5, "failed to initialize parser: " + exception);
        }
    }

    public void readFile(String string, HashMap<Tagpath, SchemaNode> hashMap) throws JNCException {
        this.readFile(new InputSource(string), hashMap);
    }

    public void readFile(URL uRL, HashMap<Tagpath, SchemaNode> hashMap) throws JNCException {
        try {
            this.readFile(new InputSource(uRL.openStream()), hashMap);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new JNCException(-5, "Unable to open file: " + uRL + ": " + iOException);
        }
    }

    private void readFile(InputSource inputSource, HashMap<Tagpath, SchemaNode> hashMap) throws JNCException {
        try {
            SchemaHandler schemaHandler = new SchemaHandler(hashMap);
            this.parser.setContentHandler(schemaHandler);
            this.parser.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JNCException(-5, "parse file: " + inputSource + " error: " + exception);
        }
    }

    public void findAndReadFile(String string, HashMap<Tagpath, SchemaNode> hashMap, Class clazz) throws JNCException {
        URL uRL = clazz.getResource(string);
        if (uRL == null) {
            throw new JNCException(-5, "Cannot find file: " + string + " on the classpath.");
        }
        this.readFile(uRL, hashMap);
    }

    private class SchemaHandler
    extends DefaultHandler {
        protected HashMap<Tagpath, SchemaNode> h;
        protected SchemaNode node;
        protected RevisionInfo ri;
        protected ArrayList<RevisionInfo> riArrayList;
        protected String value = null;

        SchemaHandler(HashMap<Tagpath, SchemaNode> hashMap) {
            this.h = hashMap;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string2.equals("node")) {
                this.node = new SchemaNode();
                this.value = null;
            } else if (string2.equals("rev")) {
                this.riArrayList = new ArrayList();
                this.value = null;
            } else if (string2.equals("info")) {
                this.ri = new RevisionInfo();
                this.value = null;
            } else {
                this.value = string2.equals("schema") || string2.equals("node") ? null : "";
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (string2.equals("node")) {
                this.h.put(this.node.tagpath, this.node);
            } else if (string2.equals("tagpath")) {
                String[] stringArray = this.value.split("/");
                if (stringArray.length == 0) {
                    this.node.tagpath = new Tagpath(0);
                } else {
                    this.node.tagpath = new Tagpath(stringArray.length - 1);
                    System.arraycopy(stringArray, 1, this.node.tagpath.p, 0, stringArray.length - 1);
                }
            } else if (string2.equals("namespace")) {
                this.node.namespace = this.value;
            } else if (string2.equals("primitive_type")) {
                this.node.primitive_type = Integer.parseInt(this.value);
            } else if (string2.equals("min_occurs")) {
                this.node.min_occurs = Integer.parseInt(this.value);
            } else if (string2.equals("max_occurs")) {
                this.node.max_occurs = Integer.parseInt(this.value);
            } else if (string2.equals("children")) {
                String[] stringArray = this.value.split(" ");
                if (stringArray.length == 0) {
                    this.node.children = null;
                } else {
                    this.node.children = new String[stringArray.length];
                    System.arraycopy(stringArray, 0, this.node.children, 0, stringArray.length);
                }
            } else if (string2.equals("flags")) {
                this.node.flags = Integer.parseInt(this.value);
            } else if (string2.equals("desc")) {
                this.node.desc = this.value;
            } else if (string2.equals("type")) {
                this.ri.type = Integer.parseInt(this.value);
            } else if (string2.equals("idata")) {
                this.ri.idata = Integer.parseInt(this.value);
            } else if (string2.equals("data")) {
                this.ri.data = this.value;
            } else if (string2.equals("introduced")) {
                this.ri.introduced = this.value;
            } else if (string2.equals("info")) {
                this.riArrayList.add(this.ri);
            } else if (string2.equals("rev")) {
                RevisionInfo[] revisionInfoArray = new RevisionInfo[this.riArrayList.size()];
                this.node.revInfo = this.riArrayList.toArray(revisionInfoArray);
            }
            this.value = null;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.value == null) {
                return;
            }
            this.value = this.value + new String(cArray, n, n2);
        }
    }
}

