/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Utils;
import com.tailf.jnc.YangBaseType;
import com.tailf.jnc.YangException;
import java.math.BigDecimal;

abstract class YangBaseInt<T extends Number>
extends YangBaseType<T> {
    private static final long serialVersionUID = 1L;
    protected BigDecimal MIN_VALUE = null;
    protected BigDecimal MAX_VALUE = null;

    public YangBaseInt(String string) throws YangException {
        super(string);
    }

    public YangBaseInt(T t) throws YangException {
        super(t);
        YangException.throwException(!this.valid(((Number)t).longValue()), this);
    }

    protected void setMinMax(Number number, Number number2) throws YangException {
        this.MIN_VALUE = Utils.bigDecimalValueOf(number);
        this.MAX_VALUE = Utils.bigDecimalValueOf(number2);
        if (this.MIN_VALUE == null || this.MAX_VALUE == null) {
            return;
        }
        YangException.throwException(this.MIN_VALUE.compareTo(this.MAX_VALUE) > 0, this);
    }

    protected boolean valid(Number number) {
        if (this.MIN_VALUE == null && this.MAX_VALUE == null) {
            return true;
        }
        BigDecimal bigDecimal = Utils.bigDecimalValueOf(number);
        boolean bl = true;
        if (this.MIN_VALUE != null) {
            boolean bl2 = bl = bigDecimal.compareTo(this.MIN_VALUE) >= 0;
        }
        if (this.MAX_VALUE != null) {
            bl &= bigDecimal.compareTo(this.MAX_VALUE) <= 0;
        }
        return bl;
    }

    @Override
    public void check() throws YangException {
        super.check();
        YangException.throwException(!this.valid((Number)this.getValue()), this);
    }

    protected abstract T decode(String var1) throws NumberFormatException;

    @Override
    protected final T fromString(String string) throws YangException {
        try {
            return this.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new YangException(-1026, (Object)numberFormatException);
        }
    }

    @Override
    public boolean canEqual(Object object) {
        return object instanceof YangBaseInt;
    }

    protected void exact(Number number) throws YangException {
        YangException.throwException(!this.valid(number), number);
        Utils.restrict(this.value, number, Utils.Operator.EQ);
    }

    protected void min(Number number) throws YangException {
        YangException.throwException(!this.valid(number), number);
        Utils.restrict(this.value, number, Utils.Operator.GE);
    }

    protected void max(Number number) throws YangException {
        YangException.throwException(!this.valid(number), number);
        Utils.restrict(this.value, number, Utils.Operator.LE);
    }
}

