/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.YangBaseString;
import com.tailf.jnc.YangException;
import java.util.Arrays;

public class YangEnumeration
extends YangBaseString {
    private static final long serialVersionUID = 1L;
    private String[] enums;

    protected String[] enums() {
        return this.enums;
    }

    public YangEnumeration(String string, String[] stringArray) throws YangException {
        super(string);
        if (string.isEmpty()) {
            YangException.throwException(true, "empty string in enum value");
        } else if (stringArray == null || stringArray.length == 0) {
            YangException.throwException(true, "no enum names provided");
        }
        this.pattern("[^ ]|[^ ].*[^ ]");
        this.enums = stringArray;
    }

    @Override
    public void check() throws YangException {
        if (this.enums == null) {
            return;
        }
        super.check();
        boolean bl = false;
        for (String string : this.enums) {
            bl |= ((String)this.value).equals(string);
        }
        YangException.throwException(!bl, "\"" + (String)this.value + "\" not valid" + "enum name");
    }

    @Override
    public boolean canEqual(Object object) {
        return object instanceof YangEnumeration;
    }

    @Override
    public boolean equals(Object object) {
        return this.canEqual(object) && Arrays.equals(this.enums, ((YangEnumeration)object).enums) && super.equals(object);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        return this.enums == null ? n : n + Arrays.hashCode(this.enums);
    }

    @Override
    protected YangEnumeration cloneShallow() throws YangException {
        return new YangEnumeration((String)this.value, this.enums);
    }
}

