/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Utils;
import com.tailf.jnc.YangBaseInt;
import com.tailf.jnc.YangException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class YangUInt64
extends YangBaseInt<BigInteger> {
    private static final long serialVersionUID = 1L;

    public YangUInt64(String string) throws YangException {
        super(string);
        this.setMinMax(0, new BigInteger("18446744073709551615"));
        this.check();
    }

    public YangUInt64(Number number) throws YangException {
        this(number.toString());
    }

    @Override
    public void setValue(Number number) throws YangException {
        try {
            super.setValue(Utils.bigDecimalValueOf(number).toBigIntegerExact());
        }
        catch (ArithmeticException arithmeticException) {
            YangException.throwException(true, arithmeticException);
        }
    }

    @Override
    protected BigInteger decode(String string) throws NumberFormatException {
        try {
            return new BigDecimal(string).toBigIntegerExact();
        }
        catch (ArithmeticException arithmeticException) {
            throw new NumberFormatException(arithmeticException.toString());
        }
    }

    protected YangUInt64 cloneShallow() throws YangException {
        return new YangUInt64(this.toString());
    }
}

