/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Objects;
import java.util.Set;
import org.onlab.graph.Edge;
import org.onlab.graph.Graph;
import org.onlab.graph.Vertex;

public class AdjacencyListsGraph<V extends Vertex, E extends Edge<V>>
implements Graph<V, E> {
    private final Set<V> vertexes;
    private final Set<E> edges;
    private final ImmutableSetMultimap<V, E> sources;
    private final ImmutableSetMultimap<V, E> destinations;

    public AdjacencyListsGraph(Set<V> vertexes, Set<E> edges) {
        Preconditions.checkNotNull(vertexes, (Object)"Vertex set cannot be null");
        Preconditions.checkNotNull(edges, (Object)"Edge set cannot be null");
        ImmutableSetMultimap.Builder srcMap = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder dstMap = ImmutableSetMultimap.builder();
        ImmutableSet.Builder actualVertexes = ImmutableSet.builder();
        actualVertexes.addAll(vertexes);
        for (Edge edge : edges) {
            srcMap.put(edge.src(), (Object)edge);
            actualVertexes.add(edge.src());
            dstMap.put(edge.dst(), (Object)edge);
            actualVertexes.add(edge.dst());
        }
        this.edges = ImmutableSet.copyOf(edges);
        this.vertexes = actualVertexes.build();
        this.sources = srcMap.build();
        this.destinations = dstMap.build();
    }

    @Override
    public Set<V> getVertexes() {
        return this.vertexes;
    }

    @Override
    public Set<E> getEdges() {
        return this.edges;
    }

    @Override
    public Set<E> getEdgesFrom(V src) {
        return this.sources.get(src);
    }

    @Override
    public Set<E> getEdgesTo(V dst) {
        return this.destinations.get(dst);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AdjacencyListsGraph) {
            AdjacencyListsGraph that = (AdjacencyListsGraph)obj;
            return this.getClass() == that.getClass() && Objects.equals(this.vertexes, that.vertexes) && Objects.equals(this.edges, that.edges);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.vertexes, this.edges);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("vertexes", this.vertexes).add("edges", this.edges).toString();
    }
}

