/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.EAP;
import org.onlab.packet.EAPOLMkpdu;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketUtils;

public class EAPOL
extends BasePacket {
    private byte version = (byte)3;
    private byte eapolType;
    private short packetLength;
    private static final int HEADER_LENGTH = 4;
    public static final byte EAPOL_PACKET = 0;
    public static final byte EAPOL_START = 1;
    public static final byte EAPOL_LOGOFF = 2;
    public static final byte EAPOL_KEY = 3;
    public static final byte EAPOL_ASF = 4;
    public static final byte EAPOL_MKA = 5;
    public static final MacAddress PAE_GROUP_ADDR = MacAddress.valueOf(new byte[]{1, -128, -62, 0, 0, 3});

    public byte getVersion() {
        return this.version;
    }

    public EAPOL setVersion(byte version) {
        this.version = version;
        return this;
    }

    public byte getEapolType() {
        return this.eapolType;
    }

    public EAPOL setEapolType(byte eapolType) {
        this.eapolType = eapolType;
        return this;
    }

    public short getPacketLength() {
        return this.packetLength;
    }

    public EAPOL setPacketLength(short packetLen) {
        this.packetLength = packetLen;
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
        }
        byte[] data = new byte[4 + this.packetLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.version);
        bb.put(this.eapolType);
        bb.putShort(this.packetLength);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        return data;
    }

    @Override
    public int hashCode() {
        int prime = 3889;
        int result = super.hashCode();
        result = 3889 * result + this.version;
        result = 3889 * result + this.eapolType;
        result = 3889 * result + this.packetLength;
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EAPOL)) {
            return false;
        }
        EAPOL that = (EAPOL)o;
        if (this.version != that.version) {
            return false;
        }
        if (this.eapolType != that.eapolType) {
            return false;
        }
        return this.packetLength == that.packetLength;
    }

    public static Deserializer<EAPOL> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 4);
            EAPOL eapol = new EAPOL();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            eapol.setVersion(bb.get());
            eapol.setEapolType(bb.get());
            eapol.setPacketLength(bb.getShort());
            if (eapol.packetLength > 0) {
                PacketUtils.checkHeaderLength(length, 4 + eapol.packetLength);
                eapol.payload = eapol.getEapolType() == 5 ? EAPOLMkpdu.deserializer().deserialize(data, bb.position(), bb.limit() - bb.position()) : EAP.deserializer().deserialize(data, bb.position(), bb.limit() - bb.position());
                eapol.payload.setParent(eapol);
            }
            return eapol;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("version", (Object)Byte.toString(this.version)).add("eapolType", (Object)Byte.toString(this.eapolType)).add("packetLength", (Object)Short.toString(this.packetLength)).toString();
    }
}

