/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.EAPOLMkpduParameterSet;

public class EAPOLMkpduBasicParameterSet
extends BasePacket
implements EAPOLMkpduParameterSet {
    private byte mkaVersion;
    private byte keyServerPriority;
    private boolean keyServer;
    private boolean macSecDesired;
    private byte capability;
    private short bodyLength;
    private SCI sci;
    private byte[] mi;
    private int mn;
    private byte[] algAgility;
    private byte[] ckn;
    private byte[] padding;
    public static final int FIELD_ALGAG_LENGTH = 4;
    public static final int TOTAL_BPS_BODY_LENGTH = 32;
    public static final byte KEYSERVER_MASK = -128;
    public static final byte KEYSERVER_OFFSET = 7;
    public static final byte MACSEC_DESIRED_MASK = 112;
    public static final byte MACSEC_DESIRED_OFFSET = 6;
    public static final byte MACSEC_CAPABILITY_MASK = 48;
    public static final byte MACSEC_CAPABILITY_OFFSET = 4;
    public static final short BPS_FIXED_PART_SIZE_UPTO_LENGTH_FIELD = 4;
    public static final short BPS_FIXED_PART_TOTAL_SIZE = 32;

    public void setMkaVersion(byte version) {
        this.mkaVersion = version;
    }

    public byte getMkaVersion() {
        return this.mkaVersion;
    }

    public void setKeyServerPriority(byte priority) {
        this.keyServerPriority = priority;
    }

    public byte getKeyServerPriority() {
        return this.keyServerPriority;
    }

    public void setKeyServer(boolean isKeyServer) {
        this.keyServer = isKeyServer;
    }

    public boolean getKeyServer() {
        return this.keyServer;
    }

    public void setMacSecDesired(boolean desired) {
        this.macSecDesired = desired;
    }

    public boolean getMacSecDesired() {
        return this.macSecDesired;
    }

    public void setMacSecCapability(byte capability) {
        this.capability = capability;
    }

    public byte getMacSecCapacity() {
        return this.capability;
    }

    public void setBodyLength(short length) {
        this.bodyLength = length;
    }

    @Override
    public short getBodyLength() {
        return this.bodyLength;
    }

    public void setSci(byte[] sci) {
        this.sci = new SCI(sci);
    }

    public void setSci(SCI sci) {
        this.sci = sci;
    }

    public SCI getSci() {
        return this.sci;
    }

    public void setActorMI(byte[] mi) throws IllegalArgumentException {
        if (mi != null && mi.length < 12) {
            throw new IllegalArgumentException("Actor Message Identifier doesn't have enough length.");
        }
        this.mi = mi;
    }

    public byte[] getActorMI() {
        return this.mi;
    }

    public void setActorMN(byte[] mn) throws IllegalArgumentException {
        if (mn != null && mn.length < 4) {
            throw new IllegalArgumentException("Actor Message Number doesn't have enough length.");
        }
        ByteBuffer bf = ByteBuffer.wrap(mn);
        this.mn = bf.getInt();
    }

    public void setActorMN(int mn) {
        this.mn = mn;
    }

    public int getActorMN() {
        return this.mn;
    }

    public void setAlgAgility(byte[] algAgility) throws IllegalArgumentException {
        if (algAgility != null && algAgility.length < 4) {
            throw new IllegalArgumentException("Algorithm Agility doesn't have enough length.");
        }
        this.algAgility = algAgility;
    }

    public byte[] getAlgAgility() {
        return this.algAgility;
    }

    public void setCKN(byte[] ckn) {
        int cakNameLength = this.bodyLength - 32;
        if (ckn != null && ckn.length < cakNameLength) {
            throw new IllegalArgumentException("CAK name doesn't have enough length.");
        }
        this.ckn = ckn;
    }

    public byte[] getCKN() {
        return this.ckn;
    }

    public void setPadding(byte[] padding) {
        this.padding = padding;
    }

    public static Deserializer<EAPOLMkpduBasicParameterSet> deserializer() {
        return (data, offset, length) -> {
            if (length < 32) {
                return null;
            }
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            EAPOLMkpduBasicParameterSet basicParameterSet = new EAPOLMkpduBasicParameterSet();
            basicParameterSet.setMkaVersion(bb.get());
            basicParameterSet.setKeyServerPriority(bb.get());
            byte[] mbField = new byte[]{bb.get()};
            basicParameterSet.setKeyServer((mbField[0] & 0xFFFFFF80) > 0);
            basicParameterSet.setMacSecDesired((mbField[0] & 0x70) > 0);
            basicParameterSet.setMacSecCapability((byte)((mbField[0] & 0x30) >> 4));
            short bodyLength = (short)((short)(mbField[0] & 0xF) << 8);
            bodyLength = (short)(bodyLength | (short)bb.get());
            basicParameterSet.setBodyLength(bodyLength);
            mbField = new byte[8];
            bb.get(mbField, 0, 8);
            basicParameterSet.setSci(mbField);
            mbField = new byte[12];
            bb.get(mbField, 0, 12);
            basicParameterSet.setActorMI(mbField);
            mbField = new byte[4];
            bb.get(mbField, 0, 4);
            basicParameterSet.setActorMN(mbField);
            mbField = new byte[4];
            bb.get(mbField, 0, 4);
            basicParameterSet.setAlgAgility(mbField);
            int cakNameLength = basicParameterSet.getBodyLength() + 4 - 32;
            mbField = new byte[cakNameLength];
            bb.get(mbField, 0, cakNameLength);
            basicParameterSet.setCKN(mbField);
            int padLength = basicParameterSet.getBodyLength() + 4 - (32 + cakNameLength);
            if (padLength > 0) {
                mbField = new byte[padLength];
                bb.get(mbField, 0, padLength);
                basicParameterSet.setPadding(mbField);
            }
            return basicParameterSet;
        };
    }

    @Override
    public byte[] serialize() {
        short paddedLength = this.getTotalLength();
        ByteBuffer data = ByteBuffer.wrap(new byte[paddedLength]);
        data.put(this.mkaVersion);
        data.put(this.keyServerPriority);
        byte octet3 = (byte)((byte)(this.keyServer ? 1 : 0) << 7);
        octet3 = (byte)(octet3 | (byte)((byte)(this.macSecDesired ? 1 : 0) << 6));
        octet3 = (byte)(octet3 | this.capability << 4);
        paddedLength = (short)(paddedLength - 4);
        octet3 = (byte)(octet3 | (byte)(paddedLength >> 8 & 0xF));
        data.put(octet3);
        data.put((byte)paddedLength);
        data.put(this.sci.array());
        data.put(this.mi);
        data.putInt(this.mn);
        data.put(this.algAgility);
        data.put(this.ckn);
        return data.array();
    }

    @Override
    public byte getParameterSetType() {
        return 0;
    }

    @Override
    public short getTotalLength() {
        short paddedLength = (short)(32 + this.ckn.length + 3 & 0xFFFFFFFC);
        return paddedLength;
    }

    public static class SCI {
        private byte[] address;
        private short port;
        public static final int SYSTEM_IDENTIFIER_LENGTH = 6;
        public static final int PORT_OFFSET = 6;

        private boolean validateSCI(byte[] sci) {
            if (sci != null && sci.length < 8) {
                throw new IllegalArgumentException("Invalid SCI argument. Enough bytes are not provided.");
            }
            return true;
        }

        private boolean validateAddress(byte[] address) {
            if (address != null && address.length < 6) {
                throw new IllegalArgumentException("Invalid System Identifier argument. Expects 6 bytes eg. MAC address.");
            }
            return true;
        }

        public SCI(byte[] sci) {
            this.validateSCI(sci);
            this.address = Arrays.copyOfRange(sci, 0, 6);
            this.port = (short)((short)(sci[6] & 0xFF) << 8 | (short)(sci[7] & 0xFF));
        }

        public SCI(byte[] address, short port) throws IllegalArgumentException {
            this.validateAddress(address);
            this.address = address;
            this.port = port;
        }

        public void setAdddress(byte[] address) throws IllegalArgumentException {
            this.validateAddress(address);
            this.address = address;
        }

        public byte[] address() {
            return this.address;
        }

        public void setPort(short port) {
            this.port = port;
        }

        public short port() {
            return this.port;
        }

        public byte[] array() {
            byte[] data = new byte[this.address.length + 2];
            ByteBuffer bb = ByteBuffer.wrap(data);
            bb.put(this.address);
            bb.putShort(this.port);
            return bb.array();
        }
    }
}

