/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.IpAddress;

public abstract class IGMPGroup {
    protected int auxInfo;
    protected IpAddress gaddr;
    protected List<IpAddress> sources = new ArrayList<IpAddress>();

    public IGMPGroup() {
    }

    public IGMPGroup(IpAddress gaddr, int auxInfo) {
        this.gaddr = gaddr;
        this.auxInfo = auxInfo;
    }

    public IpAddress getGaddr() {
        return this.gaddr;
    }

    public int getAuxInfo() {
        return this.auxInfo;
    }

    public void addSource(IpAddress saddr) {
        this.sources.add(saddr);
    }

    public List<IpAddress> getSources() {
        return this.sources;
    }

    public abstract IGMPGroup deserialize(ByteBuffer var1) throws DeserializationException;

    public abstract byte[] serialize(ByteBuffer var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("auxInfo= ");
        sb.append(this.auxInfo);
        sb.append("gaddr= ");
        sb.append(this.gaddr);
        sb.append("sources= ");
        sb.append(this.sources.toString());
        sb.append("]");
        return sb.toString();
    }
}

