/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.onlab.packet.DHCP6;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.dhcp.Dhcp6CLTOption;
import org.onlab.packet.dhcp.Dhcp6ClientIdOption;
import org.onlab.packet.dhcp.Dhcp6IaAddressOption;
import org.onlab.packet.dhcp.Dhcp6Option;

public final class Dhcp6ClientDataOption
extends Dhcp6Option {
    private List<Dhcp6Option> options;
    private Ip6Address clientIaAddress;
    public static final int DEFAULT_LEN = 17;

    public Dhcp6ClientDataOption(Dhcp6Option dhcp6Option) {
        super(dhcp6Option);
    }

    @Override
    public short getCode() {
        return DHCP6.OptionCode.CLIENT_DATA.value();
    }

    @Override
    public short getLength() {
        return (short)this.payload.serialize().length;
    }

    @Override
    public byte[] getData() {
        return this.payload.serialize();
    }

    public List<Dhcp6Option> getOptions() {
        return this.options;
    }

    public Ip6Address getIaAddress() {
        return this.clientIaAddress;
    }

    public static Deserializer<Dhcp6Option> deserializer() {
        return (data, offset, length) -> {
            Dhcp6Option dhcp6Option = Dhcp6Option.deserializer().deserialize(data, offset, length);
            Dhcp6ClientDataOption clientData = new Dhcp6ClientDataOption(dhcp6Option);
            if (dhcp6Option.getLength() < 17) {
                throw new DeserializationException("Invalid length of Client Id option");
            }
            byte[] optionData = clientData.getData();
            clientData.options = Lists.newArrayList();
            ByteBuffer bb = ByteBuffer.wrap(optionData);
            while (bb.remaining() >= 4) {
                Dhcp6Option option;
                ByteBuffer optByteBuffer = ByteBuffer.wrap(optionData, bb.position(), optionData.length - bb.position());
                short code = optByteBuffer.getShort();
                short len = optByteBuffer.getShort();
                int optLen = 0xFFFF & len;
                byte[] subOptData = new byte[4 + optLen];
                bb.get(subOptData);
                if (code == DHCP6.OptionCode.IAADDR.value()) {
                    option = Dhcp6IaAddressOption.deserializer().deserialize(subOptData, 0, subOptData.length);
                    clientData.clientIaAddress = ((Dhcp6IaAddressOption)option).getIp6Address();
                } else {
                    option = code == DHCP6.OptionCode.CLIENTID.value() ? Dhcp6ClientIdOption.deserializer().deserialize(subOptData, 0, subOptData.length) : (code == DHCP6.OptionCode.CLIENT_LT.value() ? Dhcp6CLTOption.deserializer().deserialize(subOptData, 0, subOptData.length) : Dhcp6Option.deserializer().deserialize(subOptData, 0, subOptData.length));
                }
                clientData.options.add(option);
            }
            return clientData;
        };
    }

    @Override
    public byte[] serialize() {
        ByteBuffer bb = ByteBuffer.allocate(this.getLength() + 4);
        bb.putShort(this.getCode());
        bb.putShort(this.getLength());
        bb.put(this.payload.serialize());
        return bb.array();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("code", (int)this.getCode()).add("length", (int)this.getLength()).add("clientAddr", (Object)this.getIaAddress()).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.clientIaAddress, this.options);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dhcp6ClientDataOption)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Dhcp6ClientDataOption other = (Dhcp6ClientDataOption)obj;
        return Objects.equals(this.getCode(), other.getCode()) && Objects.equals(this.getLength(), other.getLength()) && Objects.equals(this.clientIaAddress, other.clientIaAddress) && Objects.equals(this.options, other.options);
    }
}

