/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.lacp;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.lacp.LacpBaseTlv;
import org.onlab.packet.lacp.LacpCollectorTlv;
import org.onlab.packet.lacp.LacpTerminatorTlv;
import org.onlab.packet.lacp.LacpTlv;

public class Lacp
extends BasePacket {
    public static final int HEADER_LENGTH = 1;
    public static final byte TYPE_ACTOR = 1;
    public static final byte TYPE_PARTNER = 2;
    public static final byte TYPE_COLLECTOR = 3;
    public static final byte TYPE_TERMINATOR = 0;
    private static final Map<Byte, Deserializer<? extends LacpTlv>> PROTOCOL_DESERIALIZER_MAP = ImmutableMap.builder().put((Object)1, LacpBaseTlv.deserializer()).put((Object)2, LacpBaseTlv.deserializer()).put((Object)3, LacpCollectorTlv.deserializer()).put((Object)0, LacpTerminatorTlv.deserializer()).build();
    private byte lacpVersion;
    private Map<Byte, LacpTlv> tlv = new ConcurrentHashMap<Byte, LacpTlv>();

    public byte getLacpVersion() {
        return this.lacpVersion;
    }

    public Lacp setLacpVersion(byte lacpVersion) {
        this.lacpVersion = lacpVersion;
        return this;
    }

    public Map<Byte, LacpTlv> getTlv() {
        return this.tlv;
    }

    public Lacp setTlv(Map<Byte, LacpTlv> tlv) {
        this.tlv = tlv;
        return this;
    }

    public static Deserializer<Lacp> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 1);
            Lacp lacp = new Lacp();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            lacp.setLacpVersion(bb.get());
            while (bb.limit() - bb.position() > 0) {
                int parseLength;
                byte nextType = bb.get();
                int nextLength = Byte.toUnsignedInt(bb.get());
                int n = parseLength = nextLength == 0 ? 50 : nextLength - 2;
                if (!PROTOCOL_DESERIALIZER_MAP.containsKey(nextType)) {
                    throw new DeserializationException("Unsupported LACP subtype " + Byte.toString(nextType));
                }
                Deserializer<? extends LacpTlv> deserializer = PROTOCOL_DESERIALIZER_MAP.get(nextType);
                LacpTlv tlv = deserializer.deserialize(data, bb.position(), parseLength);
                LacpTlv previousTlv = lacp.tlv.put(nextType, tlv);
                if (previousTlv != null) {
                    throw new DeserializationException("Duplicated type " + Byte.toString(nextType) + "in LACP TLV");
                }
                bb.position(bb.position() + parseLength);
            }
            return lacp;
        };
    }

    @Override
    public byte[] serialize() {
        byte[] actorInfo = Optional.ofNullable(this.tlv.get((byte)1)).map(IPacket::serialize).orElse(new byte[0]);
        byte[] partnerInfo = Optional.ofNullable(this.tlv.get((byte)2)).map(IPacket::serialize).orElse(new byte[0]);
        byte[] collectorInfo = Optional.ofNullable(this.tlv.get((byte)3)).map(IPacket::serialize).orElse(new byte[0]);
        byte[] terminatorInfo = Optional.ofNullable(this.tlv.get((byte)0)).map(IPacket::serialize).orElse(new byte[0]);
        byte[] data = new byte[3 + actorInfo.length + 2 + partnerInfo.length + 2 + collectorInfo.length + 2 + terminatorInfo.length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.lacpVersion);
        bb.put((byte)1);
        bb.put((byte)20);
        bb.put(actorInfo);
        bb.put((byte)2);
        bb.put((byte)20);
        bb.put(partnerInfo);
        bb.put((byte)3);
        bb.put((byte)16);
        bb.put(collectorInfo);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put(terminatorInfo);
        return data;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lacpVersion, this.tlv);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Lacp)) {
            return false;
        }
        Lacp other = (Lacp)obj;
        return this.lacpVersion == other.lacpVersion && Objects.equals(this.tlv, other.tlv);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("lacpVersion", (Object)Byte.toString(this.lacpVersion)).add("tlv", this.tlv).toString();
    }
}

