/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.lacp;

import java.util.Objects;

public class LacpState {
    private static final byte MASK_ACTIVE = 1;
    private static final byte MASK_TIMEOUT = 2;
    private static final byte MASK_AGG = 4;
    private static final byte MASK_SYNC = 8;
    private static final byte MASK_COLLECTING = 16;
    private static final byte MASK_DISTRIBUTING = 32;
    private static final byte MASK_DEFAULT = 64;
    private static final byte MASK_EXPIRED = -128;
    private byte state;

    public LacpState() {
        this.state = 0;
    }

    public LacpState(byte state) {
        this.state = state;
    }

    public byte toByte() {
        return this.state;
    }

    public boolean isActive() {
        return (this.state & 1) != 0;
    }

    public LacpState setActive(boolean value) {
        this.setBit((byte)1, value);
        return this;
    }

    public boolean isTimeout() {
        return (this.state & 2) != 0;
    }

    public LacpState setTimeout(boolean value) {
        this.setBit((byte)2, value);
        return this;
    }

    public boolean isAggregatable() {
        return (this.state & 4) != 0;
    }

    public LacpState setAggregatable(boolean value) {
        this.setBit((byte)4, value);
        return this;
    }

    public boolean isSync() {
        return (this.state & 8) != 0;
    }

    public LacpState setSync(boolean value) {
        this.setBit((byte)8, value);
        return this;
    }

    public boolean isCollecting() {
        return (this.state & 0x10) != 0;
    }

    public LacpState setCollecting(boolean value) {
        this.setBit((byte)16, value);
        return this;
    }

    public boolean isDistributing() {
        return (this.state & 0x20) != 0;
    }

    public LacpState setDistributing(boolean value) {
        this.setBit((byte)32, value);
        return this;
    }

    public boolean isDefault() {
        return (this.state & 0x40) != 0;
    }

    public LacpState setDefault(boolean value) {
        this.setBit((byte)64, value);
        return this;
    }

    public boolean isExpired() {
        return (this.state & 0xFFFFFF80) != 0;
    }

    public LacpState setExpired(boolean value) {
        this.setBit((byte)-128, value);
        return this;
    }

    private void setBit(byte mask, boolean value) {
        this.state = (byte)(value ? this.state | mask : this.state & ~mask);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LacpState)) {
            return false;
        }
        LacpState other = (LacpState)obj;
        return this.state == other.state;
    }

    public int hashCode() {
        return Objects.hash(this.state);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        if (this.isActive()) {
            builder.append("ACT ");
        }
        if (this.isTimeout()) {
            builder.append("STO ");
        }
        if (this.isAggregatable()) {
            builder.append("AGG ");
        }
        if (this.isSync()) {
            builder.append("SYN ");
        }
        if (this.isCollecting()) {
            builder.append("COL ");
        }
        if (this.isDistributing()) {
            builder.append("DIS ");
        }
        if (this.isDefault()) {
            builder.append("DEF ");
        }
        if (this.isExpired()) {
            builder.append("EXP ");
        }
        builder.append("}");
        return builder.toString();
    }
}

