/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ndp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.ndp.NeighborDiscoveryOptions;

public class NeighborAdvertisement
extends BasePacket {
    public static final byte HEADER_LENGTH = 20;
    protected static final byte NDP_HOP_LIMIT = 85;
    protected static final byte NDP_SOLICITED_FLAG = 1;
    protected static final byte NDP_OVERRIDE_FLAG = 1;
    protected static final byte RESERVED_CODE = 0;
    protected byte routerFlag;
    protected byte solicitedFlag;
    protected byte overrideFlag;
    protected byte[] targetAddress = new byte[16];
    private final NeighborDiscoveryOptions options = new NeighborDiscoveryOptions();

    public byte getRouterFlag() {
        return this.routerFlag;
    }

    public NeighborAdvertisement setRouterFlag(byte routerFlag) {
        this.routerFlag = routerFlag;
        return this;
    }

    public byte getSolicitedFlag() {
        return this.solicitedFlag;
    }

    public NeighborAdvertisement setSolicitedFlag(byte solicitedFlag) {
        this.solicitedFlag = solicitedFlag;
        return this;
    }

    public byte getOverrideFlag() {
        return this.overrideFlag;
    }

    public NeighborAdvertisement setOverrideFlag(byte overrideFlag) {
        this.overrideFlag = overrideFlag;
        return this;
    }

    public byte[] getTargetAddress() {
        return this.targetAddress;
    }

    public NeighborAdvertisement setTargetAddress(byte[] targetAddress) {
        this.targetAddress = Arrays.copyOfRange(targetAddress, 0, 16);
        return this;
    }

    public List<NeighborDiscoveryOptions.Option> getOptions() {
        return this.options.options();
    }

    public NeighborAdvertisement addOption(byte type, byte[] data) {
        this.options.addOption(type, data);
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] optionsData = null;
        if (this.options.hasOptions()) {
            optionsData = this.options.serialize();
        }
        int optionsLength = 0;
        if (optionsData != null) {
            optionsLength = optionsData.length;
        }
        byte[] data = new byte[20 + optionsLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putInt((this.routerFlag & 1) << 31 | (this.solicitedFlag & 1) << 30 | (this.overrideFlag & 1) << 29);
        bb.put(this.targetAddress, 0, 16);
        if (optionsData != null) {
            bb.put(optionsData);
        }
        return data;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.routerFlag;
        result = 5807 * result + this.solicitedFlag;
        result = 5807 * result + this.overrideFlag;
        ByteBuffer bb = ByteBuffer.wrap(this.targetAddress);
        for (int i = 0; i < this.targetAddress.length / 4; ++i) {
            result = 5807 * result + bb.getInt();
        }
        result = 5807 * result + this.options.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof NeighborAdvertisement)) {
            return false;
        }
        NeighborAdvertisement other = (NeighborAdvertisement)obj;
        if (this.routerFlag != other.routerFlag) {
            return false;
        }
        if (this.solicitedFlag != other.solicitedFlag) {
            return false;
        }
        if (this.overrideFlag != other.overrideFlag) {
            return false;
        }
        if (!Arrays.equals(this.targetAddress, other.targetAddress)) {
            return false;
        }
        return this.options.equals(other.options);
    }

    public static Deserializer<NeighborAdvertisement> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 20);
            NeighborAdvertisement neighborAdvertisement = new NeighborAdvertisement();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            int iscratch = bb.getInt();
            neighborAdvertisement.routerFlag = (byte)(iscratch >> 31 & 1);
            neighborAdvertisement.solicitedFlag = (byte)(iscratch >> 30 & 1);
            neighborAdvertisement.overrideFlag = (byte)(iscratch >> 29 & 1);
            bb.get(neighborAdvertisement.targetAddress, 0, 16);
            if (bb.limit() - bb.position() > 0) {
                NeighborDiscoveryOptions options = NeighborDiscoveryOptions.deserializer().deserialize(data, bb.position(), bb.limit() - bb.position());
                for (NeighborDiscoveryOptions.Option option : options.options()) {
                    neighborAdvertisement.addOption(option.type(), option.data());
                }
            }
            return neighborAdvertisement;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("routerFlag", (Object)Byte.toString(this.routerFlag)).add("solicitedFlag", (Object)Byte.toString(this.solicitedFlag)).add("overrideFlag", (Object)Byte.toString(this.overrideFlag)).add("targetAddress", (Object)Arrays.toString(this.targetAddress)).toString();
    }

    public static Ethernet buildNdpAdv(Ip6Address srcIp, MacAddress srcMac, Ethernet request) {
        Preconditions.checkNotNull((Object)srcIp, (Object)"IP address cannot be null");
        Preconditions.checkNotNull((Object)srcMac, (Object)"MAC address cannot be null");
        Preconditions.checkNotNull((Object)request, (Object)"Request cannot be null");
        Preconditions.checkArgument((request.getEtherType() == Ethernet.TYPE_IPV6 ? 1 : 0) != 0, (Object)"EtherType must be IPv6");
        IPv6 ipv6Request = (IPv6)request.getPayload();
        Preconditions.checkArgument((ipv6Request.getNextHeader() == 58 ? 1 : 0) != 0, (Object)"Protocol must be ICMP6");
        ICMP6 icmpv6 = (ICMP6)ipv6Request.getPayload();
        Preconditions.checkArgument((icmpv6.getIcmpType() == -121 ? 1 : 0) != 0, (Object)"ICMP6 type must be NEIGHBOR_SOLICITATION");
        Ethernet eth = new Ethernet();
        eth.setDestinationMACAddress(request.getSourceMAC());
        eth.setSourceMACAddress(srcMac);
        eth.setEtherType(Ethernet.TYPE_IPV6);
        eth.setVlanID(request.getVlanID());
        IPv6 ipv6 = new IPv6();
        ipv6.setSourceAddress(srcIp.toOctets());
        ipv6.setDestinationAddress(ipv6Request.getSourceAddress());
        ipv6.setHopLimit((byte)85);
        ipv6.setNextHeader((byte)58);
        ICMP6 icmp6 = new ICMP6();
        icmp6.setIcmpType((byte)-120);
        icmp6.setIcmpCode((byte)0);
        NeighborAdvertisement nadv = new NeighborAdvertisement();
        nadv.setTargetAddress(srcIp.toOctets());
        nadv.setSolicitedFlag((byte)1);
        nadv.setOverrideFlag((byte)1);
        nadv.addOption((byte)2, srcMac.toBytes());
        icmp6.setPayload(nadv);
        ipv6.setPayload(icmp6);
        eth.setPayload(ipv6);
        return eth;
    }
}

