/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ndp;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.List;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.ndp.NeighborDiscoveryOptions;

public class RouterSolicitation
extends BasePacket {
    public static final byte HEADER_LENGTH = 4;
    private final NeighborDiscoveryOptions options = new NeighborDiscoveryOptions();

    public List<NeighborDiscoveryOptions.Option> getOptions() {
        return this.options.options();
    }

    public RouterSolicitation addOption(byte type, byte[] data) {
        this.options.addOption(type, data);
        return this;
    }

    @Override
    public byte[] serialize() {
        byte[] optionsData = null;
        if (this.options.hasOptions()) {
            optionsData = this.options.serialize();
        }
        int optionsLength = 0;
        if (optionsData != null) {
            optionsLength = optionsData.length;
        }
        byte[] data = new byte[4 + optionsLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putInt(0);
        if (optionsData != null) {
            bb.put(optionsData);
        }
        return data;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.options.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RouterSolicitation)) {
            return false;
        }
        RouterSolicitation other = (RouterSolicitation)obj;
        return this.options.equals(other.options);
    }

    public static Deserializer<RouterSolicitation> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 4);
            RouterSolicitation routerSolicitation = new RouterSolicitation();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            bb.getInt();
            if (bb.limit() - bb.position() > 0) {
                NeighborDiscoveryOptions options = NeighborDiscoveryOptions.deserializer().deserialize(data, bb.position(), bb.limit() - bb.position());
                for (NeighborDiscoveryOptions.Option option : options.options()) {
                    routerSolicitation.addOption(option.type(), option.data());
                }
            }
            return routerSolicitation;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).toString();
    }
}

