/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.pim;

import java.nio.ByteBuffer;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.PacketUtils;

public class PIMAddrUnicast {
    private byte family;
    private byte encType;
    IpAddress addr;
    public static final int ENC_UNICAST_IPV4_BYTE_LENGTH = 6;
    public static final int ENC_UNICAST_IPV6_BYTE_LENGTH = 18;

    public PIMAddrUnicast() {
        this.family = 1;
        this.encType = 0;
    }

    public PIMAddrUnicast(String addr) {
        this.addr = IpAddress.valueOf(addr);
        this.family = this.addr.isIp4() ? (byte)1 : (byte)2;
        this.encType = 0;
    }

    public void setAddr(IpAddress addr) {
        this.addr = addr;
        this.family = this.addr.isIp4() ? (byte)1 : (byte)2;
    }

    public IpAddress getAddr() {
        return this.addr;
    }

    public int getFamily() {
        return this.family;
    }

    public int getByteSize() {
        int size = 2;
        size = this.addr != null ? (size += this.addr.isIp4() ? 4 : 16) : (size += 4);
        return size;
    }

    public byte[] serialize() {
        int len = this.getByteSize();
        byte[] data = new byte[len];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.family);
        bb.put(this.encType);
        bb.put(this.addr.toOctets());
        return data;
    }

    public PIMAddrUnicast deserialize(ByteBuffer bb) throws DeserializationException {
        PacketUtils.checkInput(bb.array(), bb.position(), bb.limit() - bb.position(), 6);
        this.family = bb.get();
        if (this.family != 1 && this.family != 2) {
            throw new DeserializationException("Invalid address family: " + this.family);
        }
        if (this.family == 2) {
            PacketUtils.checkInput(bb.array(), bb.position(), bb.limit() - bb.position(), 17);
        }
        this.encType = bb.get();
        if (this.family == 1) {
            this.addr = IpAddress.valueOf(bb.getInt());
        } else if (this.family == 2) {
            this.addr = Ip6Address.valueOf(bb.array(), 2);
        }
        return this;
    }

    public int hashCode() {
        int prime = 2521;
        int result = super.hashCode();
        result = 2521 * result + this.family;
        result = 2521 * result + this.encType;
        result = 2521 * result + this.addr.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PIMAddrUnicast)) {
            return false;
        }
        PIMAddrUnicast other = (PIMAddrUnicast)obj;
        if (this.family != other.family) {
            return false;
        }
        if (this.encType != other.encType) {
            return false;
        }
        return this.addr.equals(other.addr);
    }
}

