/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Generator<T>
implements Iterable<T> {
    private static ThreadGroup threadGroup;
    private Thread producer;
    private boolean hasFinished;
    private final Condition itemAvailableOrHasFinished = new Condition();
    private final Condition itemRequested = new Condition();
    private T nextItem;
    private boolean nextItemAvailable;
    private RuntimeException exceptionRaisedByProducer;

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return this.waitForNext();
            }

            @Override
            public T next() {
                if (!this.waitForNext()) {
                    throw new NoSuchElementException();
                }
                Generator.this.nextItemAvailable = false;
                return Generator.this.nextItem;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private boolean waitForNext() {
                if (Generator.this.nextItemAvailable) {
                    return true;
                }
                if (Generator.this.hasFinished) {
                    return false;
                }
                if (Generator.this.producer == null) {
                    Generator.this.startProducer();
                }
                Generator.this.itemRequested.set();
                try {
                    Generator.this.itemAvailableOrHasFinished.await();
                }
                catch (InterruptedException e) {
                    Generator.this.hasFinished = true;
                    Generator.this.producer.interrupt();
                    try {
                        Generator.this.producer.join();
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException(e1);
                    }
                }
                if (Generator.this.exceptionRaisedByProducer != null) {
                    throw Generator.this.exceptionRaisedByProducer;
                }
                return !Generator.this.hasFinished;
            }
        };
    }

    protected abstract void run() throws InterruptedException;

    public void yield(T element) throws InterruptedException {
        this.nextItem = element;
        this.nextItemAvailable = true;
        this.itemAvailableOrHasFinished.set();
        this.itemRequested.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProducer() {
        assert (this.producer == null);
        Generator generator = this;
        synchronized (generator) {
            if (threadGroup == null) {
                threadGroup = new ThreadGroup("onos-generator");
            }
        }
        this.producer = new Thread(threadGroup, () -> {
            try {
                this.itemRequested.await();
                this.run();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (RuntimeException e) {
                this.exceptionRaisedByProducer = e;
            }
            this.hasFinished = true;
            this.itemAvailableOrHasFinished.set();
        });
        this.producer.setDaemon(true);
        this.producer.start();
    }

    private class Condition {
        private boolean isSet;

        private Condition() {
        }

        synchronized void set() {
            this.isSet = true;
            this.notifyAll();
        }

        synchronized void await() throws InterruptedException {
            try {
                if (this.isSet) {
                    return;
                }
                while (!this.isSet) {
                    this.wait();
                }
            }
            finally {
                this.isSet = false;
            }
        }
    }
}

