/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class StringFilter {
    private Strategy strategy = Strategy.AND;
    private List<String> filter = new ArrayList<String>();

    public StringFilter(List<String> filter) {
        this.filter = filter;
    }

    public StringFilter(List<String> filter, Strategy strategy) {
        this(filter);
        Preconditions.checkArgument((strategy == Strategy.AND || strategy == Strategy.OR ? 1 : 0) != 0, (Object)"Chosen strategy is not allowed (should be one of {AND, OR})");
        this.strategy = strategy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean filterAnd(Object data) {
        if (this.filter.isEmpty()) return true;
        if (this.filter.stream().filter(data.toString()::contains).count() != (long)this.filter.size()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean filterOr(Object data) {
        if (this.filter.isEmpty()) return true;
        if (this.filter.stream().filter(data.toString()::contains).count() <= 0L) return false;
        return true;
    }

    public boolean filter(Object data) {
        if (this.strategy == Strategy.OR) {
            return this.filterOr(data);
        }
        return this.filterAnd(data);
    }

    public static enum Strategy {
        AND,
        OR;

    }
}

