/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class UnmodifiableDeque<E>
implements Deque<E> {
    private final Deque<E> deque;

    UnmodifiableDeque(Deque<E> deque) {
        this.deque = (Deque)Preconditions.checkNotNull(deque);
    }

    public static <T> Deque<T> unmodifiableDeque(Deque<T> deque) {
        return new UnmodifiableDeque<T>(deque);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.deque.forEach(action);
    }

    @Override
    public void addFirst(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    @Override
    public void addLast(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        return this.deque.toArray();
    }

    @Override
    public boolean offerFirst(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.deque.toArray(a);
    }

    @Override
    public boolean offerLast(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E removeFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E removeLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E getFirst() {
        return this.deque.getFirst();
    }

    @Override
    public E getLast() {
        return this.deque.getLast();
    }

    @Override
    public E peekFirst() {
        return this.deque.peekFirst();
    }

    @Override
    public E peekLast() {
        return this.deque.peekLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.deque.containsAll(c);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E poll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E element() {
        return this.deque.element();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E peek() {
        return this.deque.peek();
    }

    @Override
    public void push(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E pop() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        return this.deque.equals(o);
    }

    @Override
    public boolean contains(Object o) {
        return this.deque.contains(o);
    }

    @Override
    public int size() {
        return this.deque.size();
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.unmodifiableIterator(this.deque.iterator());
    }

    @Override
    public Iterator<E> descendingIterator() {
        return Iterators.unmodifiableIterator(this.deque.descendingIterator());
    }

    @Override
    public int hashCode() {
        return this.deque.hashCode();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.deque.spliterator();
    }

    @Override
    public Stream<E> stream() {
        return this.deque.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.deque.parallelStream();
    }

    public String toString() {
        return this.deque.toString();
    }
}

