/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.rest;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;

public class AuthorizationFilter
implements ContainerRequestFilter {
    private static final String ADMIN = "admin";
    private static final String VIEWER = "viewer";
    private static final String FORBIDDEN_MSG = "User has insufficient privilege for this request";
    private static final Set<String> PRIVILEGED_METHODS = ImmutableSet.of((Object)"POST", (Object)"PUT", (Object)"DELETE", (Object)"PATCH");
    private static boolean disableForTests = false;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (disableForTests) {
            return;
        }
        if (PRIVILEGED_METHODS.contains(requestContext.getMethod()) && !requestContext.getSecurityContext().isUserInRole(ADMIN) || !requestContext.getSecurityContext().isUserInRole(VIEWER)) {
            throw new ForbiddenException(FORBIDDEN_MSG);
        }
    }

    public static void disableForTests() {
        disableForTests = true;
    }
}

