/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.rest.exceptions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public abstract class AbstractMapper<E extends Throwable>
implements ExceptionMapper<E> {
    protected Throwable error;

    protected abstract Response.Status responseStatus();

    public Response toResponse(E exception) {
        this.error = exception;
        return this.response(this.responseStatus(), (Throwable)exception).build();
    }

    protected Response.ResponseBuilder response(Response.Status status, Throwable exception) {
        this.error = exception;
        ObjectMapper mapper = new ObjectMapper();
        String message = this.messageFrom(exception);
        ObjectNode result = mapper.createObjectNode().put("code", status.getStatusCode()).put("message", message);
        return Response.status((Response.Status)status).entity((Object)result.toString());
    }

    protected String messageFrom(Throwable exception) {
        if (Strings.isNullOrEmpty((String)exception.getMessage())) {
            StackTraceElement[] trace = exception.getStackTrace();
            return trace.length == 0 ? "Unknown error" : trace[0].toString();
        }
        return exception.getMessage();
    }
}

