/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.Partition;
import org.onosproject.cluster.PartitionId;

public class DefaultPartition
implements Partition {
    private final PartitionId id;
    private final Collection<NodeId> members;

    protected DefaultPartition() {
        this.id = null;
        this.members = null;
    }

    public DefaultPartition(PartitionId id, Collection<NodeId> members) {
        this.id = (PartitionId)Preconditions.checkNotNull((Object)id);
        this.members = ImmutableSet.copyOf(members);
    }

    public DefaultPartition(Partition other) {
        this.id = (PartitionId)Preconditions.checkNotNull((Object)other.getId());
        this.members = ImmutableSet.copyOf(other.getMembers());
    }

    @Override
    public PartitionId getId() {
        return this.id;
    }

    @Override
    public Collection<NodeId> getMembers() {
        return this.members;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id).add("members", this.members).toString();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.members);
    }

    public boolean equals(Object other) {
        if (!(other instanceof DefaultPartition)) {
            return false;
        }
        DefaultPartition that = (DefaultPartition)other;
        return this.getId().equals(that.getId()) && Sets.symmetricDifference((Set)Sets.newHashSet(this.members), (Set)Sets.newHashSet(that.members)).isEmpty();
    }
}

