/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mastership;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.onosproject.cluster.NodeId;
import org.onosproject.net.MastershipRole;

public final class MastershipInfo {
    private final long term;
    private final Optional<NodeId> master;
    private final ImmutableMap<NodeId, MastershipRole> roles;

    public MastershipInfo() {
        this(0L, Optional.empty(), (ImmutableMap<NodeId, MastershipRole>)ImmutableMap.of());
    }

    public MastershipInfo(long term, Optional<NodeId> master, ImmutableMap<NodeId, MastershipRole> roles) {
        this.term = term;
        this.master = master;
        this.roles = roles;
    }

    public long term() {
        return this.term;
    }

    public Optional<NodeId> master() {
        return this.master;
    }

    public List<NodeId> backups() {
        return this.getRoles(MastershipRole.STANDBY);
    }

    public List<NodeId> getRoles(MastershipRole role) {
        return ImmutableList.copyOf((Collection)this.roles.entrySet().stream().filter(entry -> entry.getValue() == role).map(Map.Entry::getKey).collect(Collectors.toList()));
    }

    public MastershipRole getRole(NodeId nodeId) {
        return (MastershipRole)((Object)this.roles.get((Object)nodeId));
    }

    public int hashCode() {
        return Objects.hash(this.term, this.master, this.roles);
    }

    public boolean equals(Object object) {
        if (object instanceof MastershipInfo) {
            MastershipInfo that = (MastershipInfo)object;
            return this.term == that.term && Objects.equals(this.master, that.master) && Objects.equals(this.roles, that.roles);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("term", this.term).add("master", this.master).add("roles", this.roles).toString();
    }
}

