/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.ChassisId;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.net.AbstractElement;
import org.onosproject.net.AbstractProjectableModel;
import org.onosproject.net.Annotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.DefaultDriverHandler;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.HandlerBehaviour;
import org.onosproject.net.provider.ProviderId;

public class DefaultDevice
extends AbstractElement
implements Device {
    private static final int MANUFACTURER_MAX_LENGTH = 256;
    private static final int HW_VERSION_MAX_LENGTH = 256;
    private static final int SW_VERSION_MAX_LENGTH = 256;
    private static final int SERIAL_NUMBER_MAX_LENGTH = 256;
    private final Device.Type type;
    private final String manufacturer;
    private final String serialNumber;
    private final String hwVersion;
    private final String swVersion;
    private final ChassisId chassisId;

    private DefaultDevice() {
        this.type = null;
        this.manufacturer = null;
        this.hwVersion = null;
        this.swVersion = null;
        this.serialNumber = null;
        this.chassisId = null;
    }

    public DefaultDevice(ProviderId providerId, DeviceId id, Device.Type type, String manufacturer, String hwVersion, String swVersion, String serialNumber, ChassisId chassisId, Annotations ... annotations) {
        super(providerId, id, annotations);
        if (hwVersion != null) {
            Preconditions.checkArgument((hwVersion.length() <= 256 ? 1 : 0) != 0, (Object)"hwVersion exceeds maximum length 256");
        }
        if (swVersion != null) {
            Preconditions.checkArgument((swVersion.length() <= 256 ? 1 : 0) != 0, (Object)"swVersion exceeds maximum length 256");
        }
        if (manufacturer != null) {
            Preconditions.checkArgument((manufacturer.length() <= 256 ? 1 : 0) != 0, (Object)"manufacturer exceeds maximum length 256");
        }
        if (serialNumber != null) {
            Preconditions.checkArgument((serialNumber.length() <= 256 ? 1 : 0) != 0, (Object)"serialNumber exceeds maximum length 256");
        }
        this.type = type;
        this.manufacturer = manufacturer;
        this.hwVersion = hwVersion;
        this.swVersion = swVersion;
        this.serialNumber = serialNumber;
        this.chassisId = chassisId;
    }

    @Override
    public DeviceId id() {
        return (DeviceId)this.id;
    }

    @Override
    public Device.Type type() {
        return this.type;
    }

    @Override
    public String manufacturer() {
        return this.manufacturer;
    }

    @Override
    public String hwVersion() {
        return this.hwVersion;
    }

    @Override
    public String swVersion() {
        return this.swVersion;
    }

    @Override
    public String serialNumber() {
        return this.serialNumber;
    }

    @Override
    public ChassisId chassisId() {
        return this.chassisId;
    }

    @Override
    public <B extends Behaviour> B as(Class<B> projectionClass) {
        if (HandlerBehaviour.class.isAssignableFrom(projectionClass)) {
            this.bindAndCheckDriver();
            return this.driver().createBehaviour(new DefaultDriverHandler(this.asData()), projectionClass);
        }
        return super.as(projectionClass);
    }

    @Override
    protected DriverData asData() {
        return new DeviceDriverData();
    }

    @Override
    protected Driver locateDriver() {
        try {
            return DefaultDevice.driverService().getDriver(this.id());
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.manufacturer, this.hwVersion, this.swVersion, this.serialNumber});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultDevice) {
            DefaultDevice other = (DefaultDevice)obj;
            return Objects.equals(this.id, other.id) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.hwVersion, other.hwVersion) && Objects.equals(this.swVersion, other.swVersion) && Objects.equals(this.serialNumber, other.serialNumber);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("type", (Object)this.type).add("manufacturer", (Object)this.manufacturer).add("hwVersion", (Object)this.hwVersion).add("swVersion", (Object)this.swVersion).add("serialNumber", (Object)this.serialNumber).add("driver", (Object)(this.driver() != null ? this.driver().name() : "")).toString();
    }

    protected class DeviceDriverData
    extends AbstractProjectableModel.AnnotationDriverData {
        protected DeviceDriverData() {
        }

        @Override
        public DeviceId deviceId() {
            return DefaultDevice.this.id();
        }
    }
}

