/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class TcpFlagsCriterion
implements Criterion {
    private static final int MASK = 1048575;
    private final int flags;

    TcpFlagsCriterion(int flags) {
        this.flags = flags & 0xFFFFF;
    }

    @Override
    public Criterion.Type type() {
        return Criterion.Type.TCP_FLAGS;
    }

    public int flags() {
        return this.flags;
    }

    public String toString() {
        return this.type().toString() + ":" + Long.toHexString(this.flags);
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.flags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TcpFlagsCriterion) {
            TcpFlagsCriterion that = (TcpFlagsCriterion)obj;
            return Objects.equals(this.flags, that.flags) && Objects.equals((Object)this.type(), (Object)that.type());
        }
        return false;
    }
}

