/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.instructions;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.TpPort;
import org.onosproject.net.flow.instructions.Instruction;

public abstract class L4ModificationInstruction
implements Instruction {
    public abstract L4SubType subtype();

    @Override
    public Instruction.Type type() {
        return Instruction.Type.L4MODIFICATION;
    }

    public static final class ModTransportPortInstruction
    extends L4ModificationInstruction {
        private final L4SubType subtype;
        private final TpPort port;

        public ModTransportPortInstruction(L4SubType subtype, TpPort port) {
            this.subtype = subtype;
            this.port = port;
        }

        @Override
        public L4SubType subtype() {
            return this.subtype;
        }

        public TpPort port() {
            return this.port;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.subtype().toString()).add("port", (Object)this.port).toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.port});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModTransportPortInstruction) {
                ModTransportPortInstruction that = (ModTransportPortInstruction)obj;
                return Objects.equals(this.port, that.port) && Objects.equals((Object)this.subtype(), (Object)that.subtype());
            }
            return false;
        }
    }

    public static enum L4SubType {
        TCP_SRC,
        TCP_DST,
        UDP_SRC,
        UDP_DST;

    }
}

