/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.packet;

import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;

public abstract class DefaultPacketContext
implements PacketContext {
    private final long time;
    private final InboundPacket inPkt;
    private final OutboundPacket outPkt;
    private final TrafficTreatment.Builder builder;
    private final AtomicBoolean block;

    protected DefaultPacketContext(long time, InboundPacket inPkt, OutboundPacket outPkt, boolean block) {
        this.time = time;
        this.inPkt = inPkt;
        this.outPkt = outPkt;
        this.block = new AtomicBoolean(block);
        this.builder = DefaultTrafficTreatment.builder();
    }

    @Override
    public long time() {
        AppGuard.checkPermission(AppPermission.Type.PACKET_READ);
        return this.time;
    }

    @Override
    public InboundPacket inPacket() {
        AppGuard.checkPermission(AppPermission.Type.PACKET_READ);
        return this.inPkt;
    }

    @Override
    public OutboundPacket outPacket() {
        AppGuard.checkPermission(AppPermission.Type.PACKET_READ);
        return this.outPkt;
    }

    @Override
    public TrafficTreatment.Builder treatmentBuilder() {
        AppGuard.checkPermission(AppPermission.Type.PACKET_READ);
        return this.builder;
    }

    @Override
    public abstract void send();

    @Override
    public boolean block() {
        AppGuard.checkPermission(AppPermission.Type.PACKET_WRITE);
        return this.block.getAndSet(true);
    }

    @Override
    public boolean isHandled() {
        AppGuard.checkPermission(AppPermission.Type.PACKET_READ);
        return this.block.get();
    }
}

