/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.packet.packetfilter;

import java.util.Arrays;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DHCP6;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.UDP;
import org.onlab.packet.dhcp.Dhcp6RelayOption;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketInClassifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dhcp6IndirectPacketClassifier
implements PacketInClassifier {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean match(PacketContext packet) {
        DHCP6 relayMessage;
        DHCP6 dhcp6;
        UDP udpPacket;
        IPv6 ipv6Packet;
        Ethernet eth = packet.inPacket().parsed();
        return eth.getEtherType() == Ethernet.TYPE_IPV6 && (ipv6Packet = (IPv6)eth.getPayload()).getNextHeader() == 17 && (udpPacket = (UDP)ipv6Packet.getPayload()).getDestinationPort() == 547 && udpPacket.getSourcePort() == 547 && Arrays.equals(ipv6Packet.getDestinationAddress(), Ip6Address.valueOf((String)"ff02::1:2").toOctets()) && (dhcp6 = (DHCP6)(relayMessage = (DHCP6)udpPacket.getPayload()).getOptions().stream().filter(opt -> opt instanceof Dhcp6RelayOption).map(BasePacket::getPayload).map(pld -> (DHCP6)pld).findFirst().orElse(null)).getMsgType() == DHCP6.MsgType.SOLICIT.value();
    }
}

