/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.net.resource.ContinuousResourceId;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.Resources;

@Beta
public final class ContinuousResource
implements Resource {
    private final ContinuousResourceId id;
    private final double value;

    ContinuousResource(ContinuousResourceId id, double value) {
        this.id = id;
        this.value = value;
    }

    ContinuousResource() {
        this.id = null;
        this.value = 0.0;
    }

    @Override
    public ContinuousResourceId id() {
        return this.id;
    }

    @Override
    public String simpleTypeName() {
        return this.id.simpleTypeName();
    }

    @Override
    public boolean isTypeOf(Class<?> type) {
        Preconditions.checkNotNull(type);
        return this.id.isTypeOf(type);
    }

    public double value() {
        return this.value;
    }

    @Override
    public boolean isSubTypeOf(Class<?> ancestor) {
        Preconditions.checkNotNull(ancestor);
        return this.id.isSubTypeOf(ancestor);
    }

    @Override
    public <T> Optional<T> valueAs(Class<T> type) {
        Preconditions.checkNotNull(type);
        if (type == Object.class || type == Double.TYPE || type == Double.class) {
            Double value = this.value;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @Override
    public DiscreteResource child(Object child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ContinuousResource child(Class<?> child, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<DiscreteResource> parent() {
        return this.id.parent().map(x -> Resources.discrete(x).resource());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ContinuousResource other = (ContinuousResource)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("value", this.value).toString();
    }
}

