/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.statistic;

import com.google.common.base.Preconditions;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.StoredFlowEntry;
import org.onosproject.net.statistic.DefaultLoad;
import org.onosproject.net.statistic.Load;
import org.onosproject.net.statistic.PollInterval;

public class FlowEntryWithLoad {
    private final ConnectPoint cp;
    private final FlowEntry fe;
    private final Load load;

    public FlowEntryWithLoad(ConnectPoint cp, FlowEntry fe, Load load) {
        Preconditions.checkArgument((boolean)(fe instanceof StoredFlowEntry), (Object)"FlowEntry must be StoredFlowEntry class type");
        this.cp = cp;
        this.fe = fe;
        this.load = load;
    }

    public FlowEntryWithLoad(ConnectPoint cp, FlowEntry fe) {
        Preconditions.checkArgument((boolean)(fe instanceof StoredFlowEntry), (Object)"FlowEntry must be StoredFlowEntry class type");
        this.cp = cp;
        this.fe = fe;
        this.load = new DefaultLoad(fe.bytes(), 0L, this.typedPollInterval(fe));
    }

    public ConnectPoint connectPoint() {
        return this.cp;
    }

    public StoredFlowEntry storedFlowEntry() {
        return (StoredFlowEntry)this.fe;
    }

    public Load load() {
        return this.load;
    }

    private long typedPollInterval(FlowEntry fe) {
        Preconditions.checkNotNull((Object)fe, (Object)"FlowEntry cannot be null");
        PollInterval pollIntervalInstance = PollInterval.getInstance();
        switch (fe.liveType()) {
            case LONG: {
                return pollIntervalInstance.getLongPollInterval();
            }
            case MID: {
                return pollIntervalInstance.getMidPollInterval();
            }
        }
        return pollIntervalInstance.getPollInterval();
    }
}

