/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.security;

import com.google.common.annotations.Beta;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.onosproject.security.AppPermission;

@Beta
public final class AppGuard {
    private AppGuard() {
    }

    public static void checkPermission(AppPermission.Type permission) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        AccessControlContext context = AccessController.getContext();
        if (context == null) {
            sm.checkPermission(new AppPermission(permission));
        } else {
            int contextHash = context.hashCode() ^ permission.hashCode();
            PermissionCheckCache.getInstance();
            PermissionCheckCache.checkCache(contextHash, new AppPermission(permission));
        }
    }

    private static final class PermissionCheckCache {
        private static final Cache<Integer, Boolean> CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(10L, TimeUnit.MINUTES).build();

        private PermissionCheckCache() {
        }

        public static PermissionCheckCache getInstance() {
            return SingletonHelper.INSTANCE;
        }

        public static void checkCache(int key, AppPermission perm) {
            try {
                CACHE.get((Object)key, () -> {
                    System.getSecurityManager().checkPermission(perm);
                    return true;
                });
            }
            catch (ExecutionException e) {
                System.getSecurityManager().checkPermission(perm);
            }
        }

        private static class SingletonHelper {
            private static final PermissionCheckCache INSTANCE = new PermissionCheckCache();

            private SingletonHelper() {
            }
        }
    }
}

