/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import java.util.concurrent.TimeUnit;
import org.onosproject.store.primitives.DistributedPrimitiveOptions;
import org.onosproject.store.service.DistributedPrimitive;

public abstract class LeaderElectorOptions<O extends LeaderElectorOptions<O>>
extends DistributedPrimitiveOptions<O> {
    private long electionTimeoutMillis = 15000L;

    public LeaderElectorOptions() {
        super(DistributedPrimitive.Type.LEADER_ELECTOR);
    }

    public O withElectionTimeout(long electionTimeoutMillis) {
        this.electionTimeoutMillis = electionTimeoutMillis;
        return (O)this;
    }

    public O withElectionTimeout(long electionTimeout, TimeUnit timeUnit) {
        return this.withElectionTimeout(timeUnit.toMillis(electionTimeout));
    }

    public final long electionTimeoutMillis() {
        return this.electionTimeoutMillis;
    }
}

