/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.chart;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onosproject.ui.chart.ChartModel;

public final class ChartUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private ChartUtils() {
    }

    public static ArrayNode generateDataPointArrayNode(ChartModel cm) {
        ArrayNode array = MAPPER.createArrayNode();
        for (ChartModel.DataPoint dp : cm.getDataPoints()) {
            array.add(ChartUtils.toJsonNode(dp, cm));
        }
        return array;
    }

    public static ObjectNode generateAnnotObjectNode(ChartModel cm) {
        ObjectNode node = MAPPER.createObjectNode();
        for (ChartModel.Annot a : cm.getAnnotations()) {
            node.put(a.key(), a.valueAsString());
        }
        return node;
    }

    public static JsonNode toJsonNode(ChartModel.DataPoint dp, ChartModel cm) {
        ObjectNode result = MAPPER.createObjectNode();
        String[] series = cm.getSeries();
        String[] values = dp.getAsStrings();
        int n = series.length;
        for (int i = 0; i < n; ++i) {
            result.put(series[i], values[i]);
        }
        return result;
    }
}

