/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.onlab.util.Identifier;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.PortNumber;
import org.onosproject.net.region.RegionId;

public final class UiLinkId {
    private static final String E_PORT_NULL = "Port number cannot be null";
    private static final String E_DEVICE_ID_NULL = "Device ID cannot be null";
    private static final String E_HOST_ID_NULL = "Host ID cannot be null";
    private static final String E_REGION_ID_NULL = "Region ID cannot be null";
    private static final String E_IDENTICAL = "Region IDs cannot be same";
    private static final Comparator<RegionId> REGION_ID_COMPARATOR = Comparator.comparing(Identifier::toString);
    private static final Comparator<DeviceId> DEVICE_ID_COMPARATOR = Comparator.comparing(DeviceId::toString);
    static final String CP_DELIMITER = "~";
    static final String ID_PORT_DELIMITER = "/";
    private final RegionId regionA;
    private final ElementId elementA;
    private final PortNumber portA;
    private final RegionId regionB;
    private final ElementId elementB;
    private final PortNumber portB;
    private final String idStr;
    private final String idA;
    private final String idB;
    private final Type type;

    private UiLinkId(ElementId a, PortNumber pa, ElementId b, PortNumber pb) {
        this.elementA = a;
        this.portA = pa;
        this.elementB = b;
        this.portB = pb;
        this.regionA = null;
        this.regionB = null;
        boolean isEdgeLink = a instanceof HostId;
        this.idA = isEdgeLink ? a.toString() : a + ID_PORT_DELIMITER + pa;
        this.idB = b + ID_PORT_DELIMITER + pb;
        this.idStr = this.idA + CP_DELIMITER + this.idB;
        this.type = isEdgeLink ? Type.HOST_DEVICE : Type.DEVICE_DEVICE;
    }

    private UiLinkId(RegionId a, RegionId b) {
        this.regionA = a;
        this.regionB = b;
        this.elementA = null;
        this.elementB = null;
        this.portA = null;
        this.portB = null;
        this.idA = a.toString();
        this.idB = b.toString();
        this.idStr = this.idA + CP_DELIMITER + this.idB;
        this.type = Type.REGION_REGION;
    }

    private UiLinkId(RegionId r, DeviceId d, PortNumber p) {
        this.regionA = r;
        this.elementB = d;
        this.portB = p;
        this.regionB = null;
        this.elementA = null;
        this.portA = null;
        this.idA = r.toString();
        this.idB = this.elementB + ID_PORT_DELIMITER + this.portB;
        this.idStr = this.idA + CP_DELIMITER + this.idB;
        this.type = Type.REGION_DEVICE;
    }

    public String toString() {
        return this.idStr;
    }

    public String idA() {
        return this.idA;
    }

    public String idB() {
        return this.idB;
    }

    public ElementId elementA() {
        return this.elementA;
    }

    public PortNumber portA() {
        return this.portA;
    }

    public ElementId elementB() {
        return this.elementB;
    }

    public PortNumber portB() {
        return this.portB;
    }

    public RegionId regionA() {
        return this.regionA;
    }

    public RegionId regionB() {
        return this.regionB;
    }

    public Type type() {
        return this.type;
    }

    public boolean isRegionRegion() {
        return this.type == Type.REGION_REGION;
    }

    public boolean isRegionDevice() {
        return this.type == Type.REGION_DEVICE;
    }

    public boolean isDeviceDevice() {
        return this.type == Type.DEVICE_DEVICE;
    }

    public boolean isHostDevice() {
        return this.type == Type.HOST_DEVICE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UiLinkId uiLinkId = (UiLinkId)o;
        return this.idStr.equals(uiLinkId.idStr);
    }

    public int hashCode() {
        return this.idStr.hashCode();
    }

    Direction directionOf(Link link) {
        ConnectPoint src = link.src();
        ElementId srcId = src.elementId();
        return this.elementA.equals(srcId) ? Direction.A_TO_B : (this.elementB.equals(srcId) ? Direction.B_TO_A : null);
    }

    public static UiLinkId uiLinkId(Link link) {
        return UiLinkId.canonicalizeIdentifier(link.src(), link.dst());
    }

    public static UiLinkId uiLinkId(LinkKey lk) {
        return UiLinkId.canonicalizeIdentifier(lk.src(), lk.dst());
    }

    private static UiLinkId canonicalizeIdentifier(ConnectPoint src, ConnectPoint dst) {
        if (src == null || dst == null) {
            throw new NullPointerException("null src or dst connect point (illegal for UiLinkId)");
        }
        ElementId srcId = src.elementId();
        ElementId dstId = dst.elementId();
        int comp = srcId.toString().compareTo(dstId.toString());
        return comp <= 0 ? new UiLinkId(srcId, src.port(), dstId, dst.port()) : new UiLinkId(dstId, dst.port(), srcId, src.port());
    }

    public static UiLinkId uiLinkId(RegionId one, RegionId two) {
        Preconditions.checkNotNull((Object)((Object)one), (Object)E_REGION_ID_NULL);
        Preconditions.checkNotNull((Object)((Object)two), (Object)E_REGION_ID_NULL);
        Preconditions.checkArgument((!one.equals((Object)two) ? 1 : 0) != 0, (Object)E_IDENTICAL);
        boolean flip = REGION_ID_COMPARATOR.compare(one, two) > 0;
        return flip ? new UiLinkId(two, one) : new UiLinkId(one, two);
    }

    public static UiLinkId uiLinkId(RegionId regionId, DeviceId deviceId, PortNumber portNumber) {
        Preconditions.checkNotNull((Object)((Object)regionId), (Object)E_REGION_ID_NULL);
        Preconditions.checkNotNull((Object)deviceId, (Object)E_DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)portNumber, (Object)E_PORT_NULL);
        return new UiLinkId(regionId, deviceId, portNumber);
    }

    public static UiLinkId uiLinkId(DeviceId a, PortNumber pa, DeviceId b, PortNumber pb) {
        Preconditions.checkNotNull((Object)a, (Object)"Device ID cannot be null (A)");
        Preconditions.checkNotNull((Object)b, (Object)"Device ID cannot be null (B)");
        Preconditions.checkNotNull((Object)pa, (Object)"Port number cannot be null (A)");
        Preconditions.checkNotNull((Object)pb, (Object)"Port number cannot be null (B)");
        boolean flip = DEVICE_ID_COMPARATOR.compare(a, b) > 0;
        return flip ? new UiLinkId(b, pb, a, pa) : new UiLinkId(a, pa, b, pb);
    }

    public static UiLinkId uiLinkId(HostId h, DeviceId d, PortNumber p) {
        Preconditions.checkNotNull((Object)h, (Object)E_HOST_ID_NULL);
        Preconditions.checkNotNull((Object)d, (Object)E_DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)p, (Object)E_PORT_NULL);
        return new UiLinkId(h, PortNumber.P0, d, p);
    }

    public static enum Type {
        REGION_REGION,
        REGION_DEVICE,
        DEVICE_DEVICE,
        HOST_DEVICE;

    }

    public static enum Direction {
        A_TO_B,
        B_TO_A;

    }
}

