/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.upgrade;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import org.onosproject.core.Version;

@Beta
public class Upgrade {
    private final Version source;
    private final Version target;
    private final Status status;

    public Upgrade(Version source, Version target, Status status) {
        this.source = source;
        this.target = target;
        this.status = status;
    }

    public Version source() {
        return this.source;
    }

    public Version target() {
        return this.target;
    }

    public Status status() {
        return this.status;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("target", (Object)this.target).add("status", (Object)this.status).toString();
    }

    @Beta
    public static enum Status {
        INACTIVE(false, false),
        INITIALIZING(true, false),
        INITIALIZED(true, false),
        UPGRADING(true, true),
        UPGRADED(true, true),
        COMMITTING(true, true),
        COMMITTED(false, true),
        ROLLING_BACK(true, false),
        ROLLED_BACK(true, false),
        RESETTING(true, false),
        RESET(false, false);

        private final boolean active;
        private final boolean upgraded;

        private Status(boolean active, boolean upgraded) {
            this.active = active;
            this.upgraded = upgraded;
        }

        public boolean active() {
            return this.active;
        }

        public boolean upgraded() {
            return this.upgraded;
        }
    }
}

