/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.Version;

public final class Member {
    private final NodeId nodeId;
    private final Version version;

    public Member(NodeId nodeId, Version version) {
        this.nodeId = (NodeId)Preconditions.checkNotNull((Object)nodeId);
        this.version = version;
    }

    public NodeId nodeId() {
        return this.nodeId;
    }

    public Version version() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.version);
    }

    public boolean equals(Object object) {
        if (object instanceof Member) {
            Member member = (Member)object;
            return member.nodeId.equals(this.nodeId) && Objects.equals(member.version, this.version);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeId", (Object)this.nodeId).add("version", (Object)this.version).toString();
    }
}

