/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.IpElementId;
import org.onosproject.net.PortNumber;

public class ConnectPoint
implements Comparable<ConnectPoint> {
    private static final String NO_SEP_SPECIFIED = "Connect point not specified, Connect point must be in \"deviceUri/portNumber\" format";
    private static final String SEP_NO_VALUE = "Connect point separator specified, but no port number included, connect point must  be in \"deviceUri/portNumber\" format";
    private final ElementId elementId;
    private final PortNumber portNumber;

    public ConnectPoint(ElementId elementId, PortNumber portNumber) {
        this.elementId = elementId;
        this.portNumber = portNumber;
    }

    public ElementId elementId() {
        return this.elementId;
    }

    public DeviceId deviceId() {
        if (this.elementId instanceof DeviceId) {
            return (DeviceId)this.elementId;
        }
        throw new IllegalStateException("Connection point not associated with an infrastructure device");
    }

    public HostId hostId() {
        if (this.elementId instanceof HostId) {
            return (HostId)this.elementId;
        }
        throw new IllegalStateException("Connection point not associated with an end-station host");
    }

    public IpElementId ipElementId() {
        if (this.elementId instanceof IpElementId) {
            return (IpElementId)this.elementId;
        }
        throw new IllegalStateException("Connection point not associated with an pcc client");
    }

    public PortNumber port() {
        return this.portNumber;
    }

    public static ConnectPoint deviceConnectPoint(String string) {
        Preconditions.checkNotNull((Object)string);
        int idx = string.lastIndexOf("/");
        Preconditions.checkArgument((idx != -1 ? 1 : 0) != 0, (Object)NO_SEP_SPECIFIED);
        String id = string.substring(0, idx);
        String cp = string.substring(idx + 1);
        Preconditions.checkArgument((!cp.isEmpty() ? 1 : 0) != 0, (Object)SEP_NO_VALUE);
        return new ConnectPoint(DeviceId.deviceId(id), PortNumber.portNumber(cp));
    }

    public static ConnectPoint hostConnectPoint(String string) {
        Preconditions.checkNotNull((Object)string);
        String[] splitted = string.split("/");
        Preconditions.checkArgument((splitted.length == 3 ? 1 : 0) != 0, (Object)"Connect point must be in \"hostId/vlanId/portNumber\" format");
        int lastSlash = string.lastIndexOf("/");
        return new ConnectPoint(HostId.hostId(string.substring(0, lastSlash)), PortNumber.portNumber(string.substring(lastSlash + 1, string.length())));
    }

    public static ConnectPoint fromString(String string) {
        Preconditions.checkNotNull((Object)string);
        int idx = string.lastIndexOf("/");
        Preconditions.checkArgument((idx != -1 ? 1 : 0) != 0, (Object)NO_SEP_SPECIFIED);
        String id = "";
        String cp = "";
        int nameIdx = string.lastIndexOf("[");
        if (nameIdx > 0) {
            id = string.substring(0, nameIdx - 1);
            cp = string.substring(nameIdx);
        } else if (nameIdx < 0) {
            id = string.substring(0, idx);
            cp = string.substring(idx + 1);
        }
        Preconditions.checkArgument((!cp.isEmpty() ? 1 : 0) != 0, (Object)SEP_NO_VALUE);
        return new ConnectPoint(DeviceId.deviceId(id), PortNumber.fromString(cp));
    }

    public int hashCode() {
        return Objects.hash(this.elementId, this.portNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConnectPoint) {
            ConnectPoint other = (ConnectPoint)obj;
            return Objects.equals(this.elementId, other.elementId) && Objects.equals(this.portNumber, other.portNumber);
        }
        return false;
    }

    public String toString() {
        return this.elementId + "/" + this.portNumber;
    }

    @Override
    public int compareTo(ConnectPoint o) {
        int result = this.deviceId().toString().compareTo(o.deviceId().toString());
        if (result == 0) {
            long delta = this.port().toLong() - o.port().toLong();
            result = delta == 0L ? 0 : (delta < 0L ? -1 : 1);
        }
        return result;
    }
}

