/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.onlab.util.Bandwidth;
import org.onosproject.net.AbstractDescription;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.QosDescription;
import org.onosproject.net.behaviour.QosId;
import org.onosproject.net.behaviour.QueueDescription;

@Beta
public final class DefaultQosDescription
extends AbstractDescription
implements QosDescription {
    private final QosId qosId;
    private final QosDescription.Type type;
    private final Optional<Bandwidth> maxRate;
    private final Optional<Long> cir;
    private final Optional<Long> cbs;
    private final Optional<Map<Long, QueueDescription>> queues;

    private DefaultQosDescription(QosId qosId, QosDescription.Type type, Optional<Bandwidth> maxRate, Optional<Long> cir, Optional<Long> cbs, Optional<Map<Long, QueueDescription>> queues, SparseAnnotations ... annotations) {
        super(annotations);
        this.qosId = (QosId)Preconditions.checkNotNull((Object)qosId);
        this.type = (QosDescription.Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.maxRate = maxRate;
        this.cir = cir;
        this.cbs = cbs;
        this.queues = queues;
    }

    @Override
    public QosId qosId() {
        return this.qosId;
    }

    @Override
    public QosDescription.Type type() {
        return this.type;
    }

    @Override
    public Optional<Bandwidth> maxRate() {
        return this.maxRate;
    }

    @Override
    public Optional<Long> cir() {
        return this.cir;
    }

    @Override
    public Optional<Long> cbs() {
        return this.cbs;
    }

    @Override
    public Optional<Map<Long, QueueDescription>> queues() {
        return this.queues;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.qosId, this.type, this.maxRate, this.cir, this.cbs, this.queues});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultQosDescription) {
            DefaultQosDescription other = (DefaultQosDescription)obj;
            return Objects.equals(this.qosId, other.qosId) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.maxRate, other.maxRate) && Objects.equals(this.cir, other.cir) && Objects.equals(this.cbs, other.cbs) && Objects.equals(this.queues, other.queues);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("qosId", (Object)this.qosId()).add("type", (Object)this.type()).add("maxRate", this.maxRate().orElse(null)).add("cir", (Object)this.cir().orElse(0L)).add("cbs", (Object)this.cbs().orElse(0L)).add("queues", this.queues().orElse(null)).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements QosDescription.Builder {
        private QosId qosId;
        private QosDescription.Type type;
        private Optional<Bandwidth> maxRate = Optional.empty();
        private Optional<Long> cir = Optional.empty();
        private Optional<Long> cbs = Optional.empty();
        private Optional<Map<Long, QueueDescription>> queues = Optional.empty();

        private Builder() {
        }

        @Override
        public QosDescription build() {
            return new DefaultQosDescription(this.qosId, this.type, this.maxRate, this.cir, this.cbs, this.queues, new SparseAnnotations[0]);
        }

        @Override
        public Builder qosId(QosId qosId) {
            this.qosId = qosId;
            return this;
        }

        @Override
        public Builder type(QosDescription.Type type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder maxRate(Bandwidth maxRate) {
            this.maxRate = Optional.ofNullable(maxRate);
            return this;
        }

        @Override
        public Builder cir(Long cir) {
            this.cir = Optional.ofNullable(cir);
            return this;
        }

        @Override
        public Builder cbs(Long cbs) {
            this.cbs = Optional.ofNullable(cbs);
            return this;
        }

        @Override
        public Builder queues(Map<Long, QueueDescription> queues) {
            this.queues = Optional.ofNullable(queues);
            return this;
        }
    }
}

