/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.upf;

import com.google.common.base.Preconditions;

public final class PdrStats {
    private final int cellId;
    private final long ingressPkts;
    private final long ingressBytes;
    private final long egressPkts;
    private final long egressBytes;

    private PdrStats(int cellId, long ingressPkts, long ingressBytes, long egressPkts, long egressBytes) {
        this.cellId = cellId;
        this.ingressPkts = ingressPkts;
        this.ingressBytes = ingressBytes;
        this.egressPkts = egressPkts;
        this.egressBytes = egressBytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("PDR-Stats:{ CellID: %d, Ingress:(%dpkts,%dbytes), Egress:(%dpkts,%dbytes) }", this.cellId, this.ingressPkts, this.ingressBytes, this.egressPkts, this.egressBytes);
    }

    public int getCellId() {
        return this.cellId;
    }

    public long getIngressPkts() {
        return this.ingressPkts;
    }

    public long getEgressPkts() {
        return this.egressPkts;
    }

    public long getIngressBytes() {
        return this.ingressBytes;
    }

    public long getEgressBytes() {
        return this.egressBytes;
    }

    public static class Builder {
        private Integer cellId;
        private long ingressPkts = 0L;
        private long ingressBytes = 0L;
        private long egressPkts = 0L;
        private long egressBytes = 0L;

        public Builder withCellId(int cellId) {
            this.cellId = cellId;
            return this;
        }

        public Builder setIngress(long ingressPkts, long ingressBytes) {
            this.ingressPkts = ingressPkts;
            this.ingressBytes = ingressBytes;
            return this;
        }

        public Builder setEgress(long egressPkts, long egressBytes) {
            this.egressPkts = egressPkts;
            this.egressBytes = egressBytes;
            return this;
        }

        public PdrStats build() {
            Preconditions.checkNotNull((Object)this.cellId, (Object)"CellID must be provided");
            return new PdrStats(this.cellId, this.ingressPkts, this.ingressBytes, this.egressPkts, this.egressBytes);
        }
    }
}

