/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class IPProtocolCriterion
implements Criterion {
    private static final short MASK = 255;
    private final short proto;

    IPProtocolCriterion(short protocol) {
        this.proto = (short)(protocol & 0xFF);
    }

    @Override
    public Criterion.Type type() {
        return Criterion.Type.IP_PROTO;
    }

    public short protocol() {
        return this.proto;
    }

    public String toString() {
        return this.type().toString() + ":" + this.proto;
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.proto);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IPProtocolCriterion) {
            IPProtocolCriterion that = (IPProtocolCriterion)obj;
            return Objects.equals(this.proto, that.proto);
        }
        return false;
    }
}

