/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.NextTreatment;

public final class DefaultNextTreatment
implements NextTreatment {
    private final TrafficTreatment treatment;
    private final int weight;

    private DefaultNextTreatment(TrafficTreatment treatment, int weight) {
        this.treatment = treatment;
        this.weight = weight;
    }

    public TrafficTreatment treatment() {
        return this.treatment;
    }

    public static DefaultNextTreatment of(TrafficTreatment treatment) {
        return new DefaultNextTreatment(treatment, 1);
    }

    public static DefaultNextTreatment of(TrafficTreatment treatment, int weight) {
        return new DefaultNextTreatment(treatment, weight);
    }

    @Override
    public int weight() {
        return this.weight;
    }

    @Override
    public NextTreatment.Type type() {
        return NextTreatment.Type.TREATMENT;
    }

    public int hashCode() {
        return Objects.hash(this.treatment, this.weight);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultNextTreatment) {
            DefaultNextTreatment other = (DefaultNextTreatment)obj;
            return Objects.equals(this.treatment, other.treatment) && Objects.equals(this.weight, other.weight);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("treatment", (Object)this.treatment).add("weight", this.weight).toString();
    }
}

