/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.onlab.util.Identifier;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceConsumerId;

@Beta
public final class IntentId
extends Identifier<Long>
implements ResourceConsumer {
    private static final String HEX_PREFIX = "0x";

    public static IntentId valueOf(long value) {
        return new IntentId(value);
    }

    public static IntentId valueOf(String id) {
        Preconditions.checkArgument((boolean)id.startsWith(HEX_PREFIX), (String)"Invalid id: %s", (Object)id);
        return IntentId.valueOf(Long.parseUnsignedLong(id.substring(2), 16));
    }

    IntentId() {
        super((Object)0L);
    }

    IntentId(long value) {
        super((Object)value);
    }

    public long fingerprint() {
        return (Long)this.identifier;
    }

    public String toString() {
        return HEX_PREFIX + Long.toHexString((Long)this.identifier);
    }

    @Override
    public ResourceConsumerId consumerId() {
        return ResourceConsumerId.of(this);
    }
}

