/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.Path;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.Key;

@Beta
public final class OpticalPathIntent
extends Intent {
    private final ConnectPoint src;
    private final ConnectPoint dst;
    private final Path path;
    private final OchSignal lambda;
    private final OchSignalType signalType;
    private final boolean isBidirectional;
    public static final String REVERSE_PORT_ANNOTATION_KEY = "reverse-port";

    private OpticalPathIntent(ApplicationId appId, Key key, ConnectPoint src, ConnectPoint dst, Path path, OchSignal lambda, OchSignalType signalType, boolean isBidirectional, int priority, ResourceGroup resourceGroup) {
        super(appId, key, (Collection<NetworkResource>)ImmutableSet.copyOf(path.links()), priority, resourceGroup);
        this.src = (ConnectPoint)Preconditions.checkNotNull((Object)src);
        this.dst = (ConnectPoint)Preconditions.checkNotNull((Object)dst);
        this.path = (Path)Preconditions.checkNotNull((Object)path);
        this.lambda = (OchSignal)Preconditions.checkNotNull((Object)lambda);
        this.signalType = (OchSignalType)((Object)Preconditions.checkNotNull((Object)((Object)signalType)));
        this.isBidirectional = isBidirectional;
    }

    protected OpticalPathIntent() {
        this.src = null;
        this.dst = null;
        this.path = null;
        this.lambda = null;
        this.signalType = null;
        this.isBidirectional = true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ConnectPoint src() {
        return this.src;
    }

    public ConnectPoint dst() {
        return this.dst;
    }

    public Path path() {
        return this.path;
    }

    public OchSignal lambda() {
        return this.lambda;
    }

    public OchSignalType signalType() {
        return this.signalType;
    }

    public boolean isBidirectional() {
        return this.isBidirectional;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("appId", (Object)this.appId()).add("key", (Object)this.key()).add("resources", this.resources()).add("ingressPort", (Object)this.src).add("egressPort", (Object)this.dst).add("path", (Object)this.path).add("lambda", (Object)this.lambda).add("signalType", (Object)this.signalType).add("isBidirectional", this.isBidirectional).toString();
    }

    public static class Builder
    extends Intent.Builder {
        private ConnectPoint src;
        private ConnectPoint dst;
        private Path path;
        private OchSignal lambda;
        private OchSignalType signalType;
        private boolean isBidirectional;
        private Key key;

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        @Override
        public Builder resourceGroup(ResourceGroup resourceGroup) {
            return (Builder)super.resourceGroup(resourceGroup);
        }

        public Builder src(ConnectPoint src) {
            this.src = src;
            return this;
        }

        public Builder dst(ConnectPoint dst) {
            this.dst = dst;
            return this;
        }

        public Builder path(Path path) {
            this.path = path;
            return this;
        }

        public Builder lambda(OchSignal lambda) {
            this.lambda = lambda;
            return this;
        }

        public Builder signalType(OchSignalType signalType) {
            this.signalType = signalType;
            return this;
        }

        public Builder bidirectional(boolean isBidirectional) {
            this.isBidirectional = isBidirectional;
            return this;
        }

        public OpticalPathIntent build() {
            return new OpticalPathIntent(this.appId, this.key, this.src, this.dst, this.path, this.lambda, this.signalType, this.isBidirectional, this.priority, this.resourceGroup);
        }
    }
}

