/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.meter;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.AbstractAnnotated;
import org.onosproject.net.Annotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterCellId;
import org.onosproject.net.meter.MeterEntry;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterState;

public final class DefaultMeter
extends AbstractAnnotated
implements Meter,
MeterEntry {
    private final MeterCellId cellId;
    private final Optional<ApplicationId> appId;
    private final Meter.Unit unit;
    private final boolean burst;
    private final Collection<Band> bands;
    private final DeviceId deviceId;
    private MeterState state;
    private long life;
    private long refCount;
    private long packets;
    private long bytes;

    private DefaultMeter(DeviceId deviceId, MeterCellId cellId, Optional<ApplicationId> appId, Meter.Unit unit, boolean burst, Collection<Band> bands, Annotations ... annotations) {
        super(annotations);
        this.deviceId = deviceId;
        this.cellId = cellId;
        this.appId = appId;
        this.unit = unit;
        this.burst = burst;
        this.bands = bands;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public MeterId id() {
        return this.cellId.type() == MeterCellId.MeterCellType.INDEX ? (MeterId)this.cellId : MeterId.meterId(this.cellId.hashCode());
    }

    @Override
    public MeterCellId meterCellId() {
        return this.cellId;
    }

    @Override
    public ApplicationId appId() {
        return this.appId.orElse(null);
    }

    @Override
    public Meter.Unit unit() {
        return this.unit;
    }

    @Override
    public boolean isBurst() {
        return this.burst;
    }

    @Override
    public Collection<Band> bands() {
        return this.bands;
    }

    @Override
    public MeterState state() {
        return this.state;
    }

    @Override
    public long life() {
        return this.life;
    }

    @Override
    public long referenceCount() {
        return this.refCount;
    }

    @Override
    public long packetsSeen() {
        return this.packets;
    }

    @Override
    public long bytesSeen() {
        return this.bytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void setState(MeterState state) {
        this.state = state;
    }

    @Override
    public void setLife(long life) {
        this.life = life;
    }

    @Override
    public void setReferenceCount(long count) {
        this.refCount = count;
    }

    @Override
    public void setProcessedPackets(long packets) {
        this.packets = packets;
    }

    @Override
    public void setProcessedBytes(long bytes) {
        this.bytes = bytes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("device", (Object)this.deviceId).add("cellId", (Object)this.cellId).add("appId", this.appId.orElse(null)).add("unit", (Object)this.unit).add("isBurst", this.burst).add("state", (Object)this.state).add("bands", this.bands).add("annotations", (Object)this.annotations()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMeter that = (DefaultMeter)o;
        return Objects.equal((Object)this.cellId, (Object)that.cellId) && Objects.equal(this.appId, that.appId) && Objects.equal((Object)((Object)this.unit), (Object)((Object)that.unit)) && Objects.equal((Object)this.deviceId, (Object)that.deviceId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.cellId, this.appId, this.unit, this.deviceId});
    }

    public static final class Builder
    implements Meter.Builder {
        private MeterCellId cellId;
        private Optional<ApplicationId> appId = Optional.empty();
        private Meter.Unit unit = Meter.Unit.KB_PER_SEC;
        private boolean burst = false;
        private Collection<Band> bands;
        private DeviceId deviceId;
        private Annotations annotations;

        @Override
        public Meter.Builder forDevice(DeviceId deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public Meter.Builder withId(MeterId id) {
            this.withCellId(id);
            return this;
        }

        @Override
        public Meter.Builder withCellId(MeterCellId cellId) {
            this.cellId = cellId;
            return this;
        }

        @Override
        public Meter.Builder fromApp(ApplicationId appId) {
            this.appId = Optional.ofNullable(appId);
            return this;
        }

        @Override
        public Meter.Builder withUnit(Meter.Unit unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public Meter.Builder burst() {
            this.burst = true;
            return this;
        }

        @Override
        public Meter.Builder withBands(Collection<Band> bands) {
            this.bands = ImmutableSet.copyOf(bands);
            return this;
        }

        @Override
        public Builder withAnnotations(Annotations anns) {
            this.annotations = anns;
            return this;
        }

        @Override
        public DefaultMeter build() {
            Preconditions.checkNotNull((Object)this.deviceId, (Object)"Must specify a device");
            Preconditions.checkNotNull(this.bands, (Object)"Must have bands.");
            Preconditions.checkArgument((!this.bands.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one band.");
            Preconditions.checkArgument((this.cellId != null ? 1 : 0) != 0, (Object)"Must specify a cell id.");
            return new DefaultMeter(this.deviceId, this.cellId, this.appId, this.unit, this.burst, this.bands, this.annotations);
        }
    }
}

