/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.model.PiActionProfileId;
import org.onosproject.net.pi.runtime.PiActionProfileGroupHandle;
import org.onosproject.net.pi.runtime.PiActionProfileGroupId;
import org.onosproject.net.pi.runtime.PiActionProfileMember;
import org.onosproject.net.pi.runtime.PiActionProfileMemberId;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiEntityType;

@Beta
public final class PiActionProfileGroup
implements PiEntity {
    private final PiActionProfileId actionProfileId;
    private final PiActionProfileGroupId groupId;
    private final ImmutableMap<PiActionProfileMemberId, WeightedMember> members;
    private final int maxSize;

    private PiActionProfileGroup(PiActionProfileGroupId groupId, ImmutableMap<PiActionProfileMemberId, WeightedMember> members, PiActionProfileId actionProfileId, int maxSize) {
        this.groupId = groupId;
        this.members = members;
        this.actionProfileId = actionProfileId;
        this.maxSize = maxSize;
    }

    public PiActionProfileGroupId id() {
        return this.groupId;
    }

    public Collection<WeightedMember> members() {
        return this.members.values();
    }

    public Optional<WeightedMember> member(PiActionProfileMemberId memberId) {
        return Optional.of((WeightedMember)this.members.get((Object)memberId));
    }

    public int maxSize() {
        return this.maxSize;
    }

    public PiActionProfileId actionProfile() {
        return this.actionProfileId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PiActionProfileGroup other = (PiActionProfileGroup)obj;
        return Objects.equal((Object)this.groupId, (Object)other.groupId) && Objects.equal(this.members, other.members) && Objects.equal((Object)((Object)this.actionProfileId), (Object)((Object)other.actionProfileId));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.groupId, this.members, this.maxSize, this.actionProfileId});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("actionProfile", (Object)this.actionProfileId).add("id", (Object)this.groupId).add("members", (Object)this.members.values()).add("maxSize", this.maxSize).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public PiEntityType piEntityType() {
        return PiEntityType.ACTION_PROFILE_GROUP;
    }

    @Override
    public PiActionProfileGroupHandle handle(DeviceId deviceId) {
        return PiActionProfileGroupHandle.of(deviceId, this);
    }

    public static final class WeightedMember {
        public static final int DEFAULT_WEIGHT = 1;
        private final PiActionProfileMemberId memberId;
        private final int weight;
        private final PiActionProfileMember memberInstance;

        public WeightedMember(PiActionProfileMemberId memberId, int weight) {
            Preconditions.checkNotNull((Object)memberId);
            this.memberId = memberId;
            this.weight = weight;
            this.memberInstance = null;
        }

        public WeightedMember(PiActionProfileMember memberInstance, int weight) {
            Preconditions.checkNotNull((Object)memberInstance);
            this.memberId = memberInstance.id();
            this.weight = weight;
            this.memberInstance = memberInstance;
        }

        public PiActionProfileMemberId id() {
            return this.memberId;
        }

        public int weight() {
            return this.weight;
        }

        public PiActionProfileMember instance() {
            return this.memberInstance;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.memberId, this.weight});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            WeightedMember other = (WeightedMember)obj;
            return Objects.equal((Object)this.memberId, (Object)other.memberId) && Objects.equal((Object)this.weight, (Object)other.weight);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("memberId", (Object)this.memberId).add("weight", this.weight).toString();
        }
    }

    public static final class Builder {
        private PiActionProfileGroupId groupId;
        private Map<PiActionProfileMemberId, WeightedMember> members = Maps.newHashMap();
        private PiActionProfileId actionProfileId;
        private int maxSize;

        private Builder() {
        }

        public Builder withId(PiActionProfileGroupId id) {
            this.groupId = id;
            return this;
        }

        public Builder addMember(WeightedMember member) {
            Preconditions.checkNotNull((Object)member);
            this.members.put(member.id(), member);
            return this;
        }

        public Builder addMember(PiActionProfileMemberId memberId) {
            this.addMember(new WeightedMember(memberId, 1));
            return this;
        }

        public Builder addMember(PiActionProfileMember memberInstance) {
            this.addMember(new WeightedMember(memberInstance, 1));
            return this;
        }

        public Builder addMembers(Iterable<PiActionProfileMember> memberInstances) {
            memberInstances.forEach(this::addMember);
            return this;
        }

        public Builder addMember(PiActionProfileMemberId memberId, int weight) {
            this.addMember(new WeightedMember(memberId, weight));
            return this;
        }

        public Builder addMember(PiActionProfileMember memberInstance, int weight) {
            this.addMember(new WeightedMember(memberInstance, weight));
            return this;
        }

        public Builder withActionProfileId(PiActionProfileId piActionProfileId) {
            this.actionProfileId = piActionProfileId;
            return this;
        }

        public Builder withMaxSize(int maxSize) {
            Preconditions.checkArgument((maxSize >= 0 ? 1 : 0) != 0, (Object)"maxSize cannot be negative");
            this.maxSize = maxSize;
            return this;
        }

        public PiActionProfileGroup build() {
            Preconditions.checkNotNull((Object)this.groupId);
            Preconditions.checkNotNull((Object)((Object)this.actionProfileId));
            Preconditions.checkArgument((this.maxSize == 0 || this.members.size() <= this.maxSize ? 1 : 0) != 0, (Object)"The number of members cannot exceed maxSize");
            boolean validActionProfileId = this.members.isEmpty() || this.members.values().stream().allMatch(m -> m.instance() == null || m.instance().actionProfile().equals((Object)this.actionProfileId));
            Preconditions.checkArgument((boolean)validActionProfileId, (Object)"The members' action profile ID must match the group one");
            return new PiActionProfileGroup(this.groupId, (ImmutableMap<PiActionProfileMemberId, WeightedMember>)ImmutableMap.copyOf(this.members), this.actionProfileId, this.maxSize);
        }
    }
}

