/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Set;
import org.onosproject.net.pi.runtime.PiAction;
import org.onosproject.net.pi.runtime.PiTableAction;

@Beta
public final class PiActionSet
implements PiTableAction {
    private final Set<WeightedAction> actionSet;

    private PiActionSet(Set<WeightedAction> actionSet) {
        this.actionSet = actionSet;
    }

    public Set<WeightedAction> actions() {
        return this.actionSet;
    }

    @Override
    public PiTableAction.Type type() {
        return PiTableAction.Type.ACTION_SET;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiActionSet that = (PiActionSet)o;
        return Objects.equal(this.actionSet, that.actionSet);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.actionSet});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("actionSet", this.actionSet).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class WeightedAction {
        public static final int DEFAULT_WEIGHT = 1;
        private final int weight;
        private final PiAction action;

        public WeightedAction(PiAction action, int weight) {
            this.weight = weight;
            this.action = action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WeightedAction that = (WeightedAction)o;
            return this.weight == that.weight && Objects.equal((Object)this.action, (Object)that.action);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.weight, this.action});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("weight", this.weight).add("action", (Object)this.action).toString();
        }

        public int weight() {
            return this.weight;
        }

        public PiAction action() {
            return this.action;
        }
    }

    public static final class Builder {
        private final Set<WeightedAction> actionSet = Sets.newHashSet();

        private Builder() {
        }

        public Builder addWeightedAction(PiAction action, int weight) {
            this.actionSet.add(new WeightedAction(action, weight));
            return this;
        }

        public PiActionSet build() {
            return new PiActionSet(Set.copyOf(this.actionSet));
        }
    }
}

