/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.pi.model.PiCounterId;
import org.onosproject.net.pi.model.PiCounterType;
import org.onosproject.net.pi.runtime.PiTableEntry;

@Beta
public final class PiCounterCellId {
    private final PiCounterId counterId;
    private final PiCounterType counterType;
    private final long index;
    private final PiTableEntry tableEntry;

    private PiCounterCellId(PiCounterId counterId, PiCounterType counterType, long index, PiTableEntry tableEntry) {
        this.counterId = counterId;
        this.counterType = counterType;
        this.index = index;
        this.tableEntry = tableEntry;
    }

    public PiCounterId counterId() {
        return this.counterId;
    }

    public PiCounterType counterType() {
        return this.counterType;
    }

    public long index() {
        return this.index;
    }

    public PiTableEntry tableEntry() {
        return this.tableEntry;
    }

    public static PiCounterCellId ofDirect(PiTableEntry tableEntry) {
        Preconditions.checkNotNull((Object)tableEntry);
        return new PiCounterCellId(null, PiCounterType.DIRECT, -1L, tableEntry);
    }

    public static PiCounterCellId ofIndirect(PiCounterId counterId, long index) {
        Preconditions.checkNotNull((Object)((Object)counterId));
        Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"Index must be a positive number");
        return new PiCounterCellId(counterId, PiCounterType.INDIRECT, index, null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PiCounterCellId other = (PiCounterCellId)obj;
        return Objects.equal((Object)((Object)this.counterId), (Object)((Object)other.counterId)) && Objects.equal((Object)((Object)this.counterType), (Object)((Object)other.counterType)) && Objects.equal((Object)this.index, (Object)other.index) && Objects.equal((Object)this.tableEntry, (Object)other.tableEntry);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.counterId, this.counterType, this.index, this.tableEntry});
    }

    public String toString() {
        return this.counterType == PiCounterType.DIRECT ? this.tableEntry.toString() : this.counterId.toString() + ":" + String.valueOf(this.index);
    }
}

