/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiMeterBand;
import org.onosproject.net.pi.runtime.PiMeterBandType;
import org.onosproject.net.pi.runtime.PiMeterCellHandle;
import org.onosproject.net.pi.runtime.PiMeterCellId;

@Beta
public final class PiMeterCellConfig
implements PiEntity {
    private final PiMeterCellId cellId;
    private final ImmutableMap<PiMeterBandType, PiMeterBand> piMeterBands;

    private PiMeterCellConfig(PiMeterCellId cellId, Map<PiMeterBandType, PiMeterBand> piMeterBands) {
        this.cellId = cellId;
        this.piMeterBands = ImmutableMap.copyOf(piMeterBands);
    }

    public PiMeterCellId cellId() {
        return this.cellId;
    }

    public Map<PiMeterBandType, PiMeterBand> meterBands() {
        return this.piMeterBands;
    }

    public boolean isModifyConfig() {
        return this.piMeterBands.size() == 2;
    }

    public boolean isDefaultConfig() {
        return this.piMeterBands.isEmpty();
    }

    public PiMeterBand committedBand() {
        return (PiMeterBand)this.piMeterBands.get((Object)PiMeterBandType.COMMITTED);
    }

    public PiMeterBand peakBand() {
        return (PiMeterBand)this.piMeterBands.get((Object)PiMeterBandType.PEAK);
    }

    public static PiMeterCellConfig reset(PiMeterCellId piMeterCellId) {
        return new PiMeterCellConfig(piMeterCellId, Collections.emptyMap());
    }

    @Override
    public PiEntityType piEntityType() {
        return PiEntityType.METER_CELL_CONFIG;
    }

    @Override
    public PiMeterCellHandle handle(DeviceId deviceId) {
        return PiMeterCellHandle.of(deviceId, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PiMeterCellConfig)) {
            return false;
        }
        PiMeterCellConfig that = (PiMeterCellConfig)o;
        return Objects.equal(this.piMeterBands, that.piMeterBands) && Objects.equal((Object)this.cellId, (Object)that.cellId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.cellId, this.piMeterBands});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cellId", (Object)this.cellId).add("meterBands", this.piMeterBands).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PiMeterCellId cellId;
        private Map<PiMeterBandType, PiMeterBand> bands = Maps.newHashMap();

        private Builder() {
        }

        public Builder withMeterCellId(PiMeterCellId meterCellId) {
            this.cellId = meterCellId;
            return this;
        }

        public Builder withMeterBand(PiMeterBand band) {
            this.bands.put(band.type(), band);
            return this;
        }

        public Builder withCommittedBand(long rate, long burst) {
            this.bands.put(PiMeterBandType.COMMITTED, new PiMeterBand(PiMeterBandType.COMMITTED, rate, burst));
            return this;
        }

        public Builder withPeakBand(long rate, long burst) {
            this.bands.put(PiMeterBandType.PEAK, new PiMeterBand(PiMeterBandType.PEAK, rate, burst));
            return this;
        }

        public PiMeterCellConfig build() {
            Preconditions.checkNotNull((Object)this.cellId);
            return new PiMeterCellConfig(this.cellId, this.bands);
        }
    }
}

