/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime.data;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.StringJoiner;
import org.onosproject.net.pi.model.PiData;

@Beta
public final class PiTuple
implements PiData {
    private final ImmutableList<PiData> tuple;

    private PiTuple(List<PiData> tuple) {
        this.tuple = ImmutableList.copyOf(tuple);
    }

    public static PiTuple of(List<PiData> tuple) {
        return new PiTuple(tuple);
    }

    public List<PiData> tuple() {
        return this.tuple;
    }

    @Override
    public PiData.Type type() {
        return PiData.Type.TUPLE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiTuple tp = (PiTuple)o;
        return Objects.equal(this.tuple, tp.tuple);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tuple});
    }

    public String toString() {
        StringJoiner stringParams = new StringJoiner(", ", "(", ")");
        this.tuple().forEach(p -> stringParams.add(p.toString()));
        return stringParams.toString();
    }
}

