/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.provider.ProviderRegistry;
import org.onosproject.net.provider.ProviderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProviderRegistry<P extends Provider, S extends ProviderService<P>>
implements ProviderRegistry<P, S> {
    private final Map<ProviderId, P> providers = new HashMap<ProviderId, P>();
    private final Map<ProviderId, S> services = new HashMap<ProviderId, S>();
    private final Map<String, P> providersByScheme = new HashMap<String, P>();
    private static final Logger log = LoggerFactory.getLogger(AbstractProviderRegistry.class);

    protected abstract S createProviderService(P var1);

    protected P defaultProvider() {
        return null;
    }

    @Override
    public synchronized S register(P provider) {
        log.debug("registering provider {} :{}", provider, (Object)provider.id());
        Preconditions.checkNotNull(provider, (Object)"Provider cannot be null");
        ProviderId pid = provider.id();
        Preconditions.checkState((pid.isAncillary() || !this.providersByScheme.containsKey(pid.scheme()) ? 1 : 0) != 0, (String)"A primary provider with id %s is already registered", this.providersByScheme.get(pid.scheme()));
        Preconditions.checkState((pid.isAncillary() || !this.services.containsKey(provider.id()) ? 1 : 0) != 0, (String)"Provider %s already registered", (Object)provider.id());
        ProviderService service = null;
        if (!pid.isAncillary()) {
            service = (ProviderService)this.createProviderService(provider);
            this.services.put(provider.id(), service);
            this.providers.put(provider.id(), provider);
            this.providersByScheme.put(pid.scheme(), provider);
        } else {
            ProviderId servicePid = new ProviderId(provider.id().scheme(), provider.id().id(), false);
            service = (ProviderService)this.services.get(servicePid);
            Preconditions.checkState((service != null ? 1 : 0) != 0, (String)"Primary provider with id %s not registered yet", (Object)pid);
        }
        return (S)service;
    }

    @Override
    public synchronized void unregister(P provider) {
        Preconditions.checkNotNull(provider, (Object)"Provider cannot be null");
        ProviderService service = (ProviderService)this.services.get(provider.id());
        if (service instanceof AbstractProviderService) {
            ((AbstractProviderService)service).invalidate();
            this.services.remove(provider.id());
            this.providers.remove(provider.id());
            if (!provider.id().isAncillary()) {
                this.providersByScheme.remove(provider.id().scheme());
            }
        }
    }

    @Override
    public synchronized Set<ProviderId> getProviders() {
        return ImmutableSet.copyOf(this.services.keySet());
    }

    protected synchronized P getProvider(ProviderId providerId) {
        Provider provider = (Provider)this.providers.get(providerId);
        return (P)(provider != null ? provider : this.defaultProvider());
    }

    protected synchronized P getProvider(DeviceId deviceId) {
        Provider provider = (Provider)this.providersByScheme.get(deviceId.uri().getScheme());
        return (P)(provider != null ? provider : this.defaultProvider());
    }

    protected synchronized P getProvider(String scheme) {
        return (P)((Provider)this.providersByScheme.get(scheme));
    }
}

